/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.PropertyPlaceholderDelegateRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.util.URISupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.switchyard.Exchange;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.SwitchYardRouteDefinition;
import org.switchyard.component.camel.composer.CamelBindingData;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.transaction.TransactionManagerFactory;
import org.switchyard.component.common.selector.OperationSelector;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class InboundHandler
extends BaseServiceHandler {
    public static final String OPERATION_SELECTOR_REF = "_operatoinSelector";
    private static final String TRANSACTED_REF = "transactionPolicy";
    private static TransactionManagerFactory TM_FACTORY = TransactionManagerFactory.getInstance();
    private final CamelBindingModel _camelBindingModel;
    private final ModelCamelContext _camelContext;
    private RouteDefinition _routeDefinition;
    private QName _serviceName;

    public InboundHandler(CamelBindingModel camelBindingModel, ModelCamelContext camelContext, QName serviceName) {
        this._camelBindingModel = camelBindingModel;
        this._camelContext = camelContext;
        this._routeDefinition = this.createRouteDefinition(serviceName);
        this._serviceName = serviceName;
        OperationSelector selector = OperationSelectorFactory.getOperationSelectorFactory(CamelBindingData.class).newOperationSelector(camelBindingModel.getOperationSelector());
        if (selector != null) {
            selector.setDefaultNamespace(Strings.trimToNull((String)serviceName.getNamespaceURI()));
            this.addToCamelRegistry((OperationSelector<CamelBindingData>)selector);
        }
        try {
            this._camelContext.addRouteDefinition(this._routeDefinition);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private RouteDefinition createRouteDefinition(QName serviceName) {
        SwitchYardRouteDefinition route = new SwitchYardRouteDefinition(serviceName.getNamespaceURI());
        String routeId = serviceName.toString() + "-[" + this._camelBindingModel.getComponentURI() + "]";
        URI componentURI = this.uriFromBindingModel();
        route.routeId(routeId).from(componentURI.toString());
        if (this.hasTransactionManager(componentURI.toString())) {
            String tmName = this.getTransactionManagerName(componentURI);
            if (!this.isRegisteredInCamelRegistry(tmName) && this.isDefaultJtaTransactionName(tmName)) {
                PlatformTransactionManager tm = TM_FACTORY.create();
                this.addToCamelRegistry(tm, tmName);
            }
            route.transacted(TRANSACTED_REF).to(this.composeSwitchYardComponentName(serviceName));
        } else {
            route.to(this.composeSwitchYardComponentName(serviceName));
        }
        return route;
    }

    private boolean isDefaultJtaTransactionName(String tmName) {
        return tmName.equals("jtaTransactionManager");
    }

    private boolean isRegisteredInCamelRegistry(String tmName) {
        return this._camelContext.getRegistry().lookup(tmName) != null;
    }

    private void addToCamelRegistry(PlatformTransactionManager tm, String tmName) {
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)tmName, (Object)tm);
        simpleRegistry.put((Object)TRANSACTED_REF, (Object)new SpringTransactionPolicy(tm));
        PropertyPlaceholderDelegateRegistry delegateReg = (PropertyPlaceholderDelegateRegistry)this._camelContext.getRegistry();
        CompositeRegistry registry = (CompositeRegistry)delegateReg.getRegistry();
        registry.addRegistry((Registry)simpleRegistry);
    }

    private void addToCamelRegistry(OperationSelector<CamelBindingData> selector) {
        SimpleRegistry simpleRegistry = new SimpleRegistry();
        simpleRegistry.put((Object)(this._serviceName.toString() + OPERATION_SELECTOR_REF), selector);
        PropertyPlaceholderDelegateRegistry delegateReg = (PropertyPlaceholderDelegateRegistry)this._camelContext.getRegistry();
        CompositeRegistry registry = (CompositeRegistry)delegateReg.getRegistry();
        registry.addRegistry((Registry)simpleRegistry);
    }

    private boolean hasTransactionManager(String componentURI) {
        return componentURI.contains("transactionManager");
    }

    String getTransactionManagerName(URI componentURI) {
        try {
            Map parseParameters = URISupport.parseParameters((URI)componentURI);
            String name = (String)parseParameters.get("transactionManager");
            if (name != null) {
                name = name.replace("#", "");
            }
            return name;
        }
        catch (URISyntaxException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private URI uriFromBindingModel() {
        return this._camelBindingModel.getComponentURI();
    }

    private String composeSwitchYardComponentName(QName serviceName) {
        StringBuilder sb = new StringBuilder().append("switchyard://").append(serviceName.getLocalPart());
        String namespace = Strings.trimToNull((String)serviceName.getNamespaceURI());
        return SwitchYardRouteDefinition.addNamespaceParameter(sb.toString(), namespace);
    }

    public void start() {
        try {
            if (this._routeDefinition.getStatus((CamelContext)this._camelContext).isStartable()) {
                this._camelContext.startRoute(this._routeDefinition.getId());
            }
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to start route for service " + this._serviceName, (Throwable)ex);
        }
    }

    public void stop() {
        String routeId = this._routeDefinition.getId();
        try {
            this._camelContext.stopRoute(routeId);
            this._camelContext.removeRoute(routeId);
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop route for service " + this._serviceName, (Throwable)ex);
        }
    }

    public void handleMessage(Exchange switchYardExchange) {
    }

    public void handleFault(Exchange exchange) {
        System.out.println(exchange.getMessage().getContent());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._camelBindingModel == null ? 0 : this._camelBindingModel.getComponentURI().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InboundHandler other = (InboundHandler)((Object)obj);
        return !(this._camelBindingModel == null ? other._camelBindingModel != null : !this._camelBindingModel.getComponentURI().equals(other._camelBindingModel.getComponentURI()));
    }
}

