/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.log4j.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.component.camel.InboundHandler;
import org.switchyard.component.camel.OutboundHandler;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchyardEndpoint;
import org.switchyard.component.camel.composer.CamelBindingData;
import org.switchyard.component.camel.composer.CamelComposition;
import org.switchyard.component.camel.config.model.CamelBindingModel;
import org.switchyard.component.camel.config.model.CamelComponentImplementationModel;
import org.switchyard.component.camel.deploy.ComponentNameComposer;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class CamelActivator
extends BaseActivator {
    public static final String SERVICE_DOMAIN = "org.switchyard.camel.serviceDomain";
    public static final String[] CAMEL_TYPES = new String[]{"camel", "atom", "direct", "file", "ftp", "ftps", "mock", "netty-tcp", "netty-udp", "seda", "sftp", "timer", "jms", "quartz", "sql"};
    private SwitchYardCamelContext _camelContext;
    private static Logger _logger = Logger.getLogger(CamelActivator.class);
    private Configuration _environment;

    public CamelActivator(SwitchYardCamelContext context) {
        super(CAMEL_TYPES);
        this._camelContext = context;
    }

    public void setServiceDomain(ServiceDomain serviceDomain) {
        super.setServiceDomain(serviceDomain);
        this._camelContext.getWritebleRegistry().put((Object)SERVICE_DOMAIN, (Object)serviceDomain);
    }

    public ServiceHandler activateBinding(QName serviceName, BindingModel config) {
        CamelBindingModel binding = (CamelBindingModel)config;
        binding.setEnvironment(this._environment);
        if (binding.isServiceBinding()) {
            return new InboundHandler(binding, (ModelCamelContext)this._camelContext, serviceName);
        }
        return this.createOutboundHandler(binding, binding.getReference().getQName());
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        ServiceHandler handler = null;
        for (ComponentServiceModel service : config.getServices()) {
            if (!service.getQName().equals(serviceName)) continue;
            handler = this.handleImplementation(service, serviceName);
            break;
        }
        return handler;
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    private ServiceHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)config.getComponent().getImplementation();
        try {
            String endpointUri = ComponentNameComposer.composeComponentUri(serviceName);
            RouteDefinition routeDef = this.getRouteDefinition(ccim);
            this.checkSwitchYardReferencedServiceExist(routeDef, ccim);
            this.addFromEndpointToRouteDefinition(routeDef, endpointUri);
            this._camelContext.addRouteDefinition(routeDef);
            SwitchyardEndpoint endpoint = (SwitchyardEndpoint)this._camelContext.getEndpoint(endpointUri);
            endpoint.setMessageComposer(CamelComposition.getMessageComposer());
            SwitchYardConsumer consumer = endpoint.getConsumer();
            return consumer;
        }
        catch (Exception e) {
            throw new SwitchYardException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkSwitchYardReferencedServiceExist(RouteDefinition routeDef, CamelComponentImplementationModel ccim) {
        List outputs = routeDef.getOutputs();
        for (ProcessorDefinition processorDef : outputs) {
            ToDefinition to;
            URI componentUri;
            if (!(processorDef instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDef).getUri())).getScheme().equals("switchyard")) continue;
            String serviceName = componentUri.getHost();
            String namespace = ComponentNameComposer.getNamespaceFromURI(componentUri);
            QName refServiceName = new QName(namespace, serviceName);
            if (!this.containsServiceRef(ccim.getComponent().getReferences(), serviceName)) {
                throw new SwitchYardException("Could find the service reference for '" + serviceName + "'" + " which is referenced in " + to);
            }
            ServiceReference service = this.getServiceDomain().getServiceReference(refServiceName);
            if (service != null) continue;
            throw new SwitchYardException("Could find the service name '" + serviceName + "'" + " which is referenced in " + to);
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void addFromEndpointToRouteDefinition(RouteDefinition rd, String fromEndpointUri) throws Exception {
        List inputs = rd.getInputs();
        if (inputs.size() == 0) {
            inputs.add(new FromDefinition(fromEndpointUri));
        } else if (inputs.size() == 1) {
            String routeURI = ((FromDefinition)inputs.get(0)).getUri();
            if (!fromEndpointUri.equals(routeURI)) {
                throw new SwitchYardException("Endpoint URI on route " + routeURI + " does not match expected URI : " + fromEndpointUri);
            }
        } else {
            throw new SwitchYardException("A route can only have one 'from' endpoint");
        }
    }

    private RouteDefinition getRouteDefinition(CamelComponentImplementationModel model) {
        RouteDefinition routeDef = model.getRoute();
        if (routeDef == null && model.getJavaClass() != null) {
            routeDef = RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return routeDef;
    }

    private ServiceHandler createOutboundHandler(CamelBindingModel binding, QName name) {
        String endpointUri = binding.getComponentURI().toString();
        MessageComposer<CamelBindingData> messageComposer = CamelComposition.getMessageComposer(binding);
        return new OutboundHandler(endpointUri, (CamelContext)this._camelContext, messageComposer);
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

