/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.switchyard.ServiceReference;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.camel.ComponentNameComposer;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchYardEndpoint;
import org.switchyard.component.camel.SwitchYardPropertiesParser;
import org.switchyard.component.camel.common.composer.CamelComposition;
import org.switchyard.component.camel.common.deploy.BaseBindingActivator;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class CamelActivator
extends BaseBindingActivator {
    public CamelActivator(SwitchYardCamelContext context, String[] types) {
        super(context, types);
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        ServiceHandler handler = null;
        PropertiesComponent propertiesComponent = (PropertiesComponent)this.getCamelContext().getComponent("properties", PropertiesComponent.class);
        PropertyResolver pr = config.getModelConfiguration().getPropertyResolver();
        propertiesComponent.setPropertiesParser((PropertiesParser)new SwitchYardPropertiesParser(pr));
        for (ComponentServiceModel service : config.getServices()) {
            if (!service.getQName().equals(serviceName)) continue;
            handler = this.handleImplementation(service, serviceName);
            break;
        }
        return handler;
    }

    private ServiceHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)config.getComponent().getImplementation();
        try {
            String endpointUri = ComponentNameComposer.composeComponentUri((QName)serviceName);
            RouteDefinition routeDef = this.getRouteDefinition(ccim);
            this.checkSwitchYardReferencedServiceExist(routeDef, ccim);
            this.addFromEndpointToRouteDefinition(routeDef, endpointUri);
            this.getCamelContext().addRouteDefinition(routeDef);
            SwitchYardEndpoint endpoint = (SwitchYardEndpoint)this.getCamelContext().getEndpoint(endpointUri, SwitchYardEndpoint.class);
            endpoint.setMessageComposer(CamelComposition.getMessageComposer());
            SwitchYardConsumer consumer = endpoint.getConsumer();
            return consumer;
        }
        catch (Exception e) {
            throw new SwitchYardException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkSwitchYardReferencedServiceExist(RouteDefinition routeDef, CamelComponentImplementationModel ccim) {
        List outputs = routeDef.getOutputs();
        for (ProcessorDefinition processorDef : outputs) {
            ToDefinition to;
            URI componentUri;
            if (!(processorDef instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDef).getUri())).getScheme().equals("switchyard")) continue;
            String serviceName = componentUri.getHost();
            String namespace = ComponentNameComposer.getNamespaceFromURI((URI)componentUri);
            QName refServiceName = new QName(namespace, serviceName);
            if (!this.containsServiceRef(ccim.getComponent().getReferences(), serviceName)) {
                throw new SwitchYardException("Could find the service reference for '" + serviceName + "'" + " which is referenced in " + to);
            }
            ServiceReference service = this.getServiceDomain().getServiceReference(refServiceName);
            if (service != null) continue;
            throw new SwitchYardException("Could find the service name '" + serviceName + "'" + " which is referenced in " + to);
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void addFromEndpointToRouteDefinition(RouteDefinition rd, String fromEndpointUri) throws Exception {
        List inputs = rd.getInputs();
        if (inputs.size() == 0) {
            inputs.add(new FromDefinition(fromEndpointUri));
        } else if (inputs.size() == 1) {
            String routeURI = ((FromDefinition)inputs.get(0)).getUri();
            if (!fromEndpointUri.equals(routeURI)) {
                throw new SwitchYardException("Endpoint URI on route " + routeURI + " does not match expected URI : " + fromEndpointUri);
            }
        } else {
            throw new SwitchYardException("A route can only have one 'from' endpoint");
        }
    }

    private RouteDefinition getRouteDefinition(CamelComponentImplementationModel model) {
        RouteDefinition routeDef = model.getRoute();
        if (routeDef == null && model.getJavaClass() != null) {
            routeDef = RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return routeDef;
    }
}

