/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.model.v1;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.camel.model.RouteDefinition;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.common.SwitchYardRouteDefinition;
import org.switchyard.component.camel.common.model.v1.NameValueModel;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.OutputKey;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1ComponentImplementationModel;
import org.switchyard.exception.SwitchYardException;

public class V1CamelImplementationModel
extends V1ComponentImplementationModel
implements CamelComponentImplementationModel {
    private static final String CLASS = "class";
    private static final String PATH = "path";
    private static final QName ROUTE_ELEMENT = new QName("http://camel.apache.org/schema/spring", "route");
    private static JAXBContext jaxbContext = V1CamelImplementationModel.createJAXBInstance();

    public V1CamelImplementationModel() {
        super("camel", "urn:switchyard-component-camel:config:1.0");
    }

    public V1CamelImplementationModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[0]);
    }

    @Override
    public RouteDefinition getRoute() {
        RouteDefinition route = null;
        Configuration routeConfig = this.getModelConfiguration().getFirstChild("route");
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (routeConfig != null) {
                route = (RouteDefinition)unmarshaller.unmarshal(routeConfig.getSource(new OutputKey[0]));
            } else if (this.getXMLPath() != null) {
                route = (RouteDefinition)unmarshaller.unmarshal(Classes.getResource((String)this.getXMLPath()));
            }
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to load Camel XML route definition.", (Throwable)e);
        }
        String namespace = this.getComponent().getTargetNamespace();
        if (route != null && namespace != null) {
            SwitchYardRouteDefinition.addNamespaceParameter((RouteDefinition)route, (String)namespace);
        }
        return route;
    }

    public RouteDefinition addRoute() {
        if (this.getModelConfiguration().getFirstChild("route") != null) {
            throw new IllegalStateException("route element already exists in implementation!");
        }
        BaseModel routeModel = new BaseModel(ROUTE_ELEMENT){};
        this.addChildModel((Model)routeModel);
        return this.getRoute();
    }

    private static JAXBContext createJAXBInstance() {
        try {
            return JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer");
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    @Override
    public String getJavaClass() {
        Configuration classConfig = this.getModelConfiguration().getFirstChild("java");
        return classConfig != null ? classConfig.getAttribute(CLASS) : null;
    }

    @Override
    public V1CamelImplementationModel setJavaClass(String className) {
        Configuration classConfig = this.getModelConfiguration().getFirstChild("java");
        if (classConfig == null) {
            NameValueModel model = new NameValueModel(this.getNamespaceURI(), "java");
            model.getModelConfiguration().setAttribute(CLASS, className);
            this.setChildModel((Model)model);
        } else {
            classConfig.setAttribute(CLASS, className);
        }
        return this;
    }

    @Override
    public String getXMLPath() {
        Configuration classConfig = this.getModelConfiguration().getFirstChild("xml");
        return classConfig != null ? classConfig.getAttribute(PATH) : null;
    }

    @Override
    public CamelComponentImplementationModel setXMLPath(String path) {
        Configuration pathConfig = this.getModelConfiguration().getFirstChild("xml");
        if (pathConfig == null) {
            NameValueModel model = new NameValueModel(this.getNamespaceURI(), "xml");
            model.getModelConfiguration().setAttribute(PATH, path);
            this.setChildModel((Model)model);
        } else {
            pathConfig.setAttribute(PATH, path);
        }
        return this;
    }
}

