/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;

public final class RouteFactory {
    private static JAXBContext JAXB_CONTEXT;

    private RouteFactory() {
    }

    public static List<RouteDefinition> getRoutes(CamelComponentImplementationModel model) {
        if (model.getJavaClass() != null) {
            return RouteFactory.createRoute(model.getJavaClass(), model.getComponent().getTargetNamespace());
        }
        return RouteFactory.loadRoute(model.getXMLPath());
    }

    public static List<RouteDefinition> loadRoute(String xmlPath) {
        ArrayList<RouteDefinition> routes = null;
        try {
            StreamSource source = new StreamSource(Classes.getResourceAsStream((String)xmlPath));
            Object obj = JAXB_CONTEXT.createUnmarshaller().unmarshal((Source)source);
            if (obj instanceof RoutesDefinition) {
                routes = ((RoutesDefinition)obj).getRoutes();
            } else if (obj instanceof RouteDefinition) {
                routes = new ArrayList<RouteDefinition>(1);
                routes.add((RouteDefinition)obj);
            }
            if (routes == null) {
                throw new SwitchYardException("No routes found in XML file " + xmlPath);
            }
            return routes;
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
        catch (IOException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public static List<RouteDefinition> createRoute(String className) {
        return RouteFactory.createRoute(className, null);
    }

    public static List<RouteDefinition> createRoute(String className, String namespace) {
        return RouteFactory.createRoute(Classes.forName((String)className), namespace);
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass) {
        return RouteFactory.createRoute(routeClass, null);
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass, String namespace) {
        if (!RouteBuilder.class.isAssignableFrom(routeClass)) {
            throw new SwitchYardException("Java DSL class " + routeClass.getName() + " must extend " + RouteBuilder.class.getName());
        }
        try {
            RouteBuilder builder = (RouteBuilder)routeClass.newInstance();
            builder.configure();
            List routes = builder.getRouteCollection().getRoutes();
            if (routes.isEmpty()) {
                throw new SwitchYardException("No routes found in Java DSL class " + routeClass.getName());
            }
            return routes;
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to initialize Java DSL class " + routeClass.getName(), (Throwable)ex);
        }
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer", (ClassLoader)CamelContext.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }
}

