/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.deploy;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.switchyard.ServiceReference;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.camel.ComponentNameComposer;
import org.switchyard.component.camel.RouteFactory;
import org.switchyard.component.camel.SwitchYardConsumer;
import org.switchyard.component.camel.SwitchYardEndpoint;
import org.switchyard.component.camel.SwitchYardPropertiesParser;
import org.switchyard.component.camel.common.SwitchYardRouteDefinition;
import org.switchyard.component.camel.common.composer.CamelComposition;
import org.switchyard.component.camel.common.deploy.BaseCamelActivator;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class CamelActivator
extends BaseCamelActivator {
    public CamelActivator(SwitchYardCamelContext context, String ... types) {
        super(context, types);
    }

    public ServiceHandler activateService(QName serviceName, ComponentModel config) {
        ServiceHandler handler = null;
        PropertiesComponent propertiesComponent = (PropertiesComponent)this.getCamelContext().getComponent("properties", PropertiesComponent.class);
        PropertyResolver pr = config.getModelConfiguration().getPropertyResolver();
        propertiesComponent.setPropertiesParser((PropertiesParser)new SwitchYardPropertiesParser(pr));
        for (ComponentServiceModel service : config.getServices()) {
            if (!service.getQName().equals(serviceName)) continue;
            handler = this.handleImplementation(service, serviceName);
            break;
        }
        return handler;
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    private ServiceHandler handleImplementation(ComponentServiceModel config, QName serviceName) {
        CamelComponentImplementationModel ccim = (CamelComponentImplementationModel)config.getComponent().getImplementation();
        try {
            String endpointUri = ComponentNameComposer.composeComponentUri((QName)serviceName);
            List<RouteDefinition> routeDefinitions = this.getRouteDefinition(ccim);
            this.checkSwitchYardReferencedServiceExist(routeDefinitions, ccim);
            this.verifyRouteDefinitions(routeDefinitions, ccim);
            this.getCamelContext().addRouteDefinitions(routeDefinitions);
            SwitchYardEndpoint endpoint = (SwitchYardEndpoint)this.getCamelContext().getEndpoint(endpointUri, SwitchYardEndpoint.class);
            endpoint.setMessageComposer(CamelComposition.getMessageComposer());
            SwitchYardConsumer consumer = endpoint.getConsumer();
            return consumer;
        }
        catch (Exception e) {
            throw new SwitchYardException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkSwitchYardReferencedServiceExist(List<RouteDefinition> routeDefinitions, CamelComponentImplementationModel ccim) {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            List outputs = routeDefinition.getOutputs();
            for (ProcessorDefinition processorDef : outputs) {
                ToDefinition to;
                URI componentUri;
                if (!(processorDef instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDef).getUri())).getScheme().equals("switchyard")) continue;
                String serviceName = componentUri.getHost();
                String namespace = ComponentNameComposer.getNamespaceFromURI((URI)componentUri);
                QName refServiceName = new QName(namespace, serviceName);
                if (!this.containsServiceRef(ccim.getComponent().getReferences(), serviceName)) {
                    throw new SwitchYardException("Could not find the service reference for '" + serviceName + "'" + " which is referenced in " + to);
                }
                ServiceReference service = this.getServiceDomain().getServiceReference(refServiceName);
                if (service != null) continue;
                throw new SwitchYardException("Could not find the service name '" + serviceName + "'" + " which is referenced in " + to);
            }
        }
    }

    private boolean containsServiceRef(List<ComponentReferenceModel> refs, String serviceName) {
        for (ComponentReferenceModel refModel : refs) {
            if (!refModel.getName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private void verifyRouteDefinitions(List<RouteDefinition> routeDefinitions, CamelComponentImplementationModel ccim) throws Exception {
        String serviceName = ((ComponentServiceModel)ccim.getComponent().getServices().get(0)).getName();
        String compositeNs = ccim.getComponent().getComposite().getTargetNamespace();
        int serviceConsumer = 0;
        for (RouteDefinition routeDefinition : routeDefinitions) {
            if (routeDefinition.getInputs().isEmpty()) {
                throw new SwitchYardException("Every route must have at least one input");
            }
            for (FromDefinition fromDefinition : routeDefinition.getInputs()) {
                URI from = URI.create(fromDefinition.getUri());
                if (!from.getScheme().equals("switchyard")) continue;
                if (serviceConsumer > 0) {
                    throw new SwitchYardException("Only one switchyard input per implementation is allowed");
                }
                String host = from.getHost();
                String namespace = ComponentNameComposer.getNamespaceFromURI((URI)from);
                if (!serviceName.equals(host) || !compositeNs.equals(namespace)) {
                    throw new SwitchYardException("The implementation consumer doesn't match expected service " + serviceName + " and namespace " + namespace);
                }
                ++serviceConsumer;
            }
            List outputs = routeDefinition.getOutputs();
            for (ProcessorDefinition processorDefinition : outputs) {
                ToDefinition to;
                URI componentUri;
                if (!(processorDefinition instanceof ToDefinition) || !(componentUri = URI.create((to = (ToDefinition)processorDefinition).getUri())).getScheme().equals("switchyard")) continue;
                String referenceName = componentUri.getHost();
                String namespace = ComponentNameComposer.getNamespaceFromURI((URI)componentUri);
                QName refServiceName = new QName(namespace, referenceName);
                if (!this.containsServiceRef(ccim.getComponent().getReferences(), referenceName)) {
                    throw new SwitchYardException("Could not find the service reference for '" + referenceName + "'" + " which is referenced in " + to);
                }
                ServiceReference service = this.getServiceDomain().getServiceReference(refServiceName);
                if (service != null) continue;
                throw new SwitchYardException("Could not find the service name '" + referenceName + "'" + " which is referenced in " + to);
            }
        }
        if (serviceConsumer != 1) {
            throw new SwitchYardException("Can not create camel based component implementation without consuming from switchyard service");
        }
    }

    private List<RouteDefinition> getRouteDefinition(CamelComponentImplementationModel model) {
        List<RouteDefinition> routes = RouteFactory.getRoutes(model);
        for (RouteDefinition route : routes) {
            SwitchYardRouteDefinition.addNamespaceParameter((RouteDefinition)route, (String)model.getComponent().getTargetNamespace());
        }
        return routes;
    }
}

