/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.CamelModelFactory;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.type.Classes;
import org.switchyard.component.camel.CamelComponentMessages;
import org.switchyard.component.camel.model.CamelComponentImplementationModel;

public final class RouteFactory {
    private RouteFactory() {
    }

    public static List<RouteDefinition> getRoutes(CamelComponentImplementationModel model, SwitchYardCamelContext camelContext) {
        if (model.getJavaBean() != null) {
            RouteBuilder routeBuilder = RouteFactory.lookupRouteBuilder(model.getJavaBean(), camelContext);
            return RouteFactory.createRoute(routeBuilder, camelContext, model.getComponent().getTargetNamespace());
        }
        if (model.getJavaClass() != null) {
            return RouteFactory.createRoute(model.getJavaClass(), camelContext, model.getComponent().getTargetNamespace());
        }
        return RouteFactory.loadRoute(model.getXMLPath(), camelContext, model.getModelConfiguration().getPropertyResolver());
    }

    private static RouteBuilder lookupRouteBuilder(String beanName, SwitchYardCamelContext camelContext) {
        Object bean = camelContext.getRegistry().lookupByName(beanName);
        if (bean == null) {
            throw CamelComponentMessages.MESSAGES.noJavaDSLBeanFound(beanName);
        }
        if (!(bean instanceof RouteBuilder)) {
            throw CamelComponentMessages.MESSAGES.javaDSLBeanMustExtend(beanName, RouteBuilder.class.getName());
        }
        return (RouteBuilder)bean;
    }

    public static List<RouteDefinition> loadRoute(String xmlPath, SwitchYardCamelContext camelContext, PropertyResolver propertyResolver) {
        ArrayList<RouteDefinition> routes = null;
        try {
            Object obj = CamelModelFactory.createCamelModelObjectFromXML((String)xmlPath);
            if (obj instanceof CamelContextFactoryBean) {
                routes = RouteFactory.processCamelContextElement((CamelContextFactoryBean)obj, camelContext);
            } else if (obj instanceof RoutesDefinition) {
                routes = ((RoutesDefinition)obj).getRoutes();
            } else if (obj instanceof RouteDefinition) {
                routes = new ArrayList<RouteDefinition>(1);
                routes.add((RouteDefinition)obj);
            }
            if (routes == null) {
                CamelComponentMessages.MESSAGES.noRoutesFoundInXMLFile(xmlPath);
            }
            return routes;
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public static List<RouteDefinition> loadRoute(String xmlPath) {
        return RouteFactory.loadRoute(xmlPath, null, null);
    }

    private static List<RouteDefinition> processCamelContextElement(CamelContextFactoryBean camelContextFactoryBean, SwitchYardCamelContext camelContext) throws Exception {
        if (camelContext != null) {
            if (camelContextFactoryBean.getEndpoints() != null) {
                for (CamelEndpointFactoryBean epBean : camelContextFactoryBean.getEndpoints()) {
                    epBean.setCamelContext((CamelContext)camelContext);
                    camelContext.getWritebleRegistry().put((Object)epBean.getId(), (Object)epBean.getObject());
                }
            }
            if (camelContextFactoryBean.getDataFormats() != null) {
                for (DataFormatDefinition dataFormatDef : camelContextFactoryBean.getDataFormats().getDataFormats()) {
                    camelContext.getDataFormats().put(dataFormatDef.getId(), dataFormatDef);
                }
            }
        }
        return camelContextFactoryBean.getRoutes();
    }

    public static List<RouteDefinition> createRoute(String className) {
        return RouteFactory.createRoute(className, null, null);
    }

    public static List<RouteDefinition> createRoute(String className, String namespace) {
        return RouteFactory.createRoute(className, null, namespace);
    }

    public static List<RouteDefinition> createRoute(String className, SwitchYardCamelContext camelContext, String namespace) {
        Class clazz = Classes.forName((String)className);
        if (clazz == null) {
            throw CamelComponentMessages.MESSAGES.invalidJavaDSLClassSpecified(className);
        }
        return RouteFactory.createRoute(RouteFactory.createRouteBuilder(clazz), camelContext, namespace);
    }

    private static RouteBuilder createRouteBuilder(Class<?> routeClass) {
        if (!RouteBuilder.class.isAssignableFrom(routeClass)) {
            throw CamelComponentMessages.MESSAGES.javaDSLClassMustExtend(routeClass.getName(), RouteBuilder.class.getName());
        }
        try {
            return (RouteBuilder)routeClass.newInstance();
        }
        catch (Exception ex) {
            throw CamelComponentMessages.MESSAGES.failedToInitializeDSLClass(routeClass.getName(), ex);
        }
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass) {
        return RouteFactory.createRoute(RouteFactory.createRouteBuilder(routeClass), null, null);
    }

    public static List<RouteDefinition> createRoute(Class<?> routeClass, SwitchYardCamelContext camelContext, String namespace) {
        return RouteFactory.createRoute(RouteFactory.createRouteBuilder(routeClass), camelContext, namespace);
    }

    public static List<RouteDefinition> createRoute(RouteBuilder routeBuilder, SwitchYardCamelContext camelContext, String namespace) {
        try {
            if (camelContext != null) {
                routeBuilder.setContext((ModelCamelContext)camelContext);
            }
            routeBuilder.configure();
            List routes = routeBuilder.getRouteCollection().getRoutes();
            if (routes.isEmpty()) {
                throw CamelComponentMessages.MESSAGES.noRoutesFoundinJavaDSLClass(routeBuilder.getClass().getName());
            }
            return routes;
        }
        catch (Exception ex) {
            throw CamelComponentMessages.MESSAGES.failedToInitializeDSLClass(routeBuilder.getClass().getName(), ex);
        }
    }
}

