/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.ATransientMap;
import clojure.lang.Counted;
import clojure.lang.IEditableCollection;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.Util;
import java.util.Iterator;
import java.util.Map;

public class PersistentArrayMap
extends APersistentMap
implements IObj,
IEditableCollection {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 16;
    public static final PersistentArrayMap EMPTY = new PersistentArrayMap();
    private final IPersistentMap _meta;

    public static IPersistentMap create(Map other) {
        ITransientMap ret = EMPTY.asTransient();
        Iterator i$ = other.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e2 = o = i$.next();
            ret = ret.assoc(e2.getKey(), e2.getValue());
        }
        return ret.persistent();
    }

    protected PersistentArrayMap() {
        this.array = new Object[0];
        this._meta = null;
    }

    public PersistentArrayMap withMeta(IPersistentMap meta2) {
        return new PersistentArrayMap(meta2, this.array);
    }

    PersistentArrayMap create(Object ... init) {
        return new PersistentArrayMap(this.meta(), init);
    }

    IPersistentMap createHT(Object[] init) {
        return PersistentHashMap.create(this.meta(), init);
    }

    public static PersistentArrayMap createWithCheck(Object[] init) {
        for (int i = 0; i < init.length; i += 2) {
            for (int j = i + 2; j < init.length; j += 2) {
                if (!PersistentArrayMap.equalKey(init[i], init[j])) continue;
                throw new IllegalArgumentException("Duplicate key: " + init[i]);
            }
        }
        return new PersistentArrayMap(init);
    }

    public PersistentArrayMap(Object[] init) {
        this.array = init;
        this._meta = null;
    }

    public PersistentArrayMap(IPersistentMap meta2, Object[] init) {
        this._meta = meta2;
        this.array = init;
    }

    public int count() {
        return this.array.length / 2;
    }

    public boolean containsKey(Object key2) {
        return this.indexOf(key2) >= 0;
    }

    public IMapEntry entryAt(Object key2) {
        int i = this.indexOf(key2);
        if (i >= 0) {
            return new MapEntry(this.array[i], this.array[i + 1]);
        }
        return null;
    }

    public IPersistentMap assocEx(Object key2, Object val2) throws Exception {
        int i = this.indexOf(key2);
        if (i >= 0) {
            throw new Exception("Key already present");
        }
        if (this.array.length > 16) {
            return this.createHT(this.array).assocEx(key2, val2);
        }
        Object[] newArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, newArray, 2, this.array.length);
        }
        newArray[0] = key2;
        newArray[1] = val2;
        return this.create(newArray);
    }

    public IPersistentMap assoc(Object key2, Object val2) {
        Object[] newArray;
        int i = this.indexOf(key2);
        if (i >= 0) {
            if (this.array[i + 1] == val2) {
                return this;
            }
            newArray = (Object[])this.array.clone();
            newArray[i + 1] = val2;
        } else {
            if (this.array.length > 16) {
                return this.createHT(this.array).assoc(key2, val2);
            }
            newArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, newArray, 2, this.array.length);
            }
            newArray[0] = key2;
            newArray[1] = val2;
        }
        return this.create(newArray);
    }

    public IPersistentMap without(Object key2) {
        int i = this.indexOf(key2);
        if (i >= 0) {
            int newlen = this.array.length - 2;
            if (newlen == 0) {
                return this.empty();
            }
            Object[] newArray = new Object[newlen];
            int d = 0;
            for (int s = 0; s < this.array.length; s += 2) {
                if (PersistentArrayMap.equalKey(this.array[s], key2)) continue;
                newArray[d] = this.array[s];
                newArray[d + 1] = this.array[s + 1];
                d += 2;
            }
            return this.create(newArray);
        }
        return this;
    }

    public IPersistentMap empty() {
        return EMPTY.withMeta(this.meta());
    }

    public final Object valAt(Object key2, Object notFound) {
        int i = this.indexOf(key2);
        if (i >= 0) {
            return this.array[i + 1];
        }
        return notFound;
    }

    public Object valAt(Object key2) {
        return this.valAt(key2, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOf(Object key2) {
        for (int i = 0; i < this.array.length; i += 2) {
            if (!PersistentArrayMap.equalKey(this.array[i], key2)) continue;
            return i;
        }
        return -1;
    }

    static boolean equalKey(Object k1, Object k2) {
        return Util.equiv(k1, k2);
    }

    public Iterator iterator() {
        return new Iter(this.array);
    }

    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    public IPersistentMap meta() {
        return this._meta;
    }

    public ITransientMap asTransient() {
        return new TransientArrayMap(this.array);
    }

    static final class TransientArrayMap
    extends ATransientMap {
        int len;
        final Object[] array;
        Thread owner = Thread.currentThread();

        public TransientArrayMap(Object[] array2) {
            this.array = new Object[Math.max(16, array2.length)];
            System.arraycopy(array2, 0, this.array, 0, array2.length);
            this.len = array2.length;
        }

        private int indexOf(Object key2) {
            for (int i = 0; i < this.len; i += 2) {
                if (!PersistentArrayMap.equalKey(this.array[i], key2)) continue;
                return i;
            }
            return -1;
        }

        ITransientMap doAssoc(Object key2, Object val2) {
            int i = this.indexOf(key2);
            if (i >= 0) {
                if (this.array[i + 1] != val2) {
                    this.array[i + 1] = val2;
                }
            } else {
                if (this.len >= this.array.length) {
                    return PersistentHashMap.create(this.array).asTransient().assoc(key2, val2);
                }
                this.array[this.len++] = key2;
                this.array[this.len++] = val2;
            }
            return this;
        }

        ITransientMap doWithout(Object key2) {
            int i = this.indexOf(key2);
            if (i >= 0) {
                if (this.len >= 2) {
                    this.array[i] = this.array[this.len - 2];
                    this.array[i + 1] = this.array[this.len - 1];
                }
                this.len -= 2;
            }
            return this;
        }

        Object doValAt(Object key2, Object notFound) {
            int i = this.indexOf(key2);
            if (i >= 0) {
                return this.array[i + 1];
            }
            return notFound;
        }

        int doCount() {
            return this.len / 2;
        }

        IPersistentMap doPersistent() {
            this.ensureEditable();
            this.owner = null;
            Object[] a = new Object[this.len];
            System.arraycopy(this.array, 0, a, 0, this.len);
            return new PersistentArrayMap(a);
        }

        void ensureEditable() {
            if (this.owner == Thread.currentThread()) {
                return;
            }
            if (this.owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }
    }

    static class Iter
    implements Iterator {
        Object[] array;
        int i;

        Iter(Object[] array2) {
            this(array2, -2);
        }

        Iter(Object[] array2, int i) {
            this.array = array2;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            this.i += 2;
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq
    implements Counted {
        final Object[] array;
        final int i;

        Seq(Object[] array2, int i) {
            this.array = array2;
            this.i = i;
        }

        public Seq(IPersistentMap meta2, Object[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        public Object first() {
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        public ISeq next() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        public int count() {
            return (this.array.length - this.i) / 2;
        }

        public Obj withMeta(IPersistentMap meta2) {
            return new Seq(meta2, this.array, this.i);
        }
    }
}

