/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.clojure.deploy;

import clojure.lang.Compiler;
import clojure.lang.Var;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.clojure.config.model.ClojureComponentImplementationModel;
import org.switchyard.component.clojure.config.model.ClojureScriptModel;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class ClojureHandler
implements ServiceHandler {
    private final ClojureComponentImplementationModel _implModel;
    private Var _var;

    public ClojureHandler(ClojureComponentImplementationModel implModel) {
        this._implModel = implModel;
    }

    public void start() {
        try {
            ClojureScriptModel scriptModel = this._implModel.getScriptModel();
            this._var = scriptModel != null ? (Var)Compiler.load((Reader)new StringReader(scriptModel.getScript())) : (Var)Compiler.load((Reader)this.loadInputStream(this._implModel.getScriptFile()));
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void stop() {
    }

    private InputStreamReader loadInputStream(String scriptFile) throws IOException {
        InputStream in = Classes.getResourceAsStream((String)scriptFile);
        if (in != null) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(new FileInputStream(scriptFile));
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            Object response;
            Object object = response = this._implModel.injectExchange() != false ? this._var.invoke((Object)exchange) : this._var.invoke(exchange.getMessage().getContent());
            if (response != null) {
                Message message = exchange.createMessage().setContent(response);
                exchange.send(message);
            }
        }
        catch (Exception e) {
            QName declaredFault = exchange.getContract().getProviderOperation().getFaultType();
            if (declaredFault != null && QNameUtil.isJavaMessageType((QName)declaredFault) && QNameUtil.toJavaMessageType((QName)declaredFault).isAssignableFrom(e.getClass())) {
                Message msg = exchange.createMessage().setContent((Object)e);
                exchange.sendFault(msg);
            }
            throw new HandlerException((Throwable)e);
        }
    }

    public void handleFault(Exchange exchange) {
    }
}

