/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.reflect.MethodAccess;
import org.switchyard.exception.SwitchYardException;

public final class SwitchYardRouteDefinition
extends RouteDefinition {
    private final String _namespace;

    public SwitchYardRouteDefinition(String namespace) {
        this._namespace = namespace;
    }

    public RouteDefinition from(String uri) {
        uri = SwitchYardRouteDefinition.addNamespaceParameter(uri, this._namespace);
        return super.from(uri);
    }

    public RouteDefinition to(String uri) {
        uri = SwitchYardRouteDefinition.addNamespaceParameter(uri, this._namespace);
        return (RouteDefinition)super.to(uri);
    }

    public static final String addNamespaceParameter(String uri, String namespace) {
        if (uri != null && uri.startsWith("switchyard://") && (namespace = Strings.trimToNull((String)namespace)) != null && !uri.contains("?namespace=") && !uri.contains("&namespace=")) {
            try {
                namespace = URLEncoder.encode(namespace, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SwitchYardException((Throwable)uee);
            }
            StringBuilder sb = new StringBuilder(uri);
            if (uri.indexOf(63) < 0) {
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append("namespace=");
            sb.append(namespace);
            uri = sb.toString();
        }
        return uri;
    }

    public static final void addNamespaceParameter(RouteDefinition route, String namespace) {
        for (FromDefinition fromDef : route.getInputs()) {
            SwitchYardRouteDefinition.addNamespaceParameterFrom(fromDef, namespace);
        }
        for (ProcessorDefinition procDef : route.getOutputs()) {
            SwitchYardRouteDefinition.addNamespaceParameterTo(procDef, namespace);
        }
    }

    private static final void addNamespaceParameterFrom(FromDefinition fromDef, String namespace) {
        String old_uri = fromDef.getUri();
        String new_uri = SwitchYardRouteDefinition.addNamespaceParameter(old_uri, namespace);
        fromDef.setUri(new_uri);
        SwitchYardRouteDefinition.setEndpointUri(fromDef.getEndpoint(), namespace);
    }

    private static final void addNamespaceParameterTo(ProcessorDefinition<?> procDef, String namespace) {
        if (procDef instanceof ToDefinition) {
            ToDefinition toDef = (ToDefinition)procDef;
            String old_uri = toDef.getUri();
            String new_uri = SwitchYardRouteDefinition.addNamespaceParameter(old_uri, namespace);
            toDef.setUri(new_uri);
            SwitchYardRouteDefinition.setEndpointUri(toDef.getEndpoint(), namespace);
        }
        for (ProcessorDefinition procDefChild : procDef.getOutputs()) {
            SwitchYardRouteDefinition.addNamespaceParameterTo(procDefChild, namespace);
        }
    }

    private static final void setEndpointUri(Endpoint endpoint, String namespace) {
        String new_uri;
        String old_uri;
        if (endpoint instanceof DefaultEndpoint && !(old_uri = endpoint.getEndpointUri()).equals(new_uri = SwitchYardRouteDefinition.addNamespaceParameter(old_uri, namespace))) {
            try {
                Method setEndpointUri = DefaultEndpoint.class.getDeclaredMethod("setEndpointUri", String.class);
                new MethodAccess(null, setEndpointUri).write((Object)((DefaultEndpoint)endpoint), (Object)new_uri);
            }
            catch (NoSuchMethodException nsfe) {
                throw new SwitchYardException((Throwable)nsfe);
            }
        }
    }
}

