/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.composer;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.common.composer.BaseRegexContextMapper;

public class CamelContextMapper
extends BaseRegexContextMapper<CamelBindingData> {
    private static final Scope[] IN_OUT = new Scope[]{Scope.IN, Scope.OUT};

    public void mapFrom(CamelBindingData source, Context context) throws Exception {
        Object value;
        String name;
        Message message = source.getMessage();
        Exchange exchange = message.getExchange();
        Scope scope = exchange.getIn() == source ? Scope.IN : Scope.OUT;
        for (Map.Entry header : message.getHeaders().entrySet()) {
            name = (String)header.getKey();
            if (!this.matches(name) || (value = header.getValue()) == null) continue;
            context.setProperty(name, value, scope).addLabels(new String[]{"camel_message_header"});
        }
        if (exchange != null) {
            for (Map.Entry property : exchange.getProperties().entrySet()) {
                name = (String)property.getKey();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                context.setProperty(name, value, Scope.EXCHANGE).addLabels(new String[]{"camel_exchange_property"});
            }
        }
    }

    public void mapTo(Context context, CamelBindingData target) throws Exception {
        Message message = target.getMessage();
        Exchange exchange = message.getExchange();
        for (Scope scope : IN_OUT) {
            for (Property property : context.getProperties(scope)) {
                Object value;
                String name = property.getName();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                message.setHeader(name, value);
            }
        }
        if (exchange != null) {
            for (Property property : context.getProperties(Scope.EXCHANGE)) {
                Object value;
                String name = property.getName();
                if (!this.matches(name) || (value = property.getValue()) == null) continue;
                exchange.setProperty(name, value);
            }
        }
    }
}

