/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.deploy;

import javax.xml.namespace.QName;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.component.camel.common.composer.CamelComposition;
import org.switchyard.component.camel.common.handler.InboundHandler;
import org.switchyard.component.camel.common.handler.OutboundHandler;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

public class BaseBindingActivator
extends BaseActivator {
    private Configuration _environment;
    private SwitchYardCamelContext _camelContext;

    protected BaseBindingActivator(SwitchYardCamelContext context, String ... types) {
        super(types);
        this._camelContext = context;
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }

    public ServiceHandler activateBinding(QName serviceName, BindingModel config) {
        CamelBindingModel binding = (CamelBindingModel)config;
        binding.setEnvironment(this._environment);
        if (binding.isServiceBinding()) {
            return new InboundHandler(binding, this._camelContext, serviceName);
        }
        return new OutboundHandler(binding.getComponentURI().toString(), this._camelContext, CamelComposition.getMessageComposer(binding));
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void deactivateService(QName name, ServiceHandler handler) {
    }

    public SwitchYardCamelContext getCamelContext() {
        return this._camelContext;
    }
}

