/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.model.v1;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.switchyard.component.camel.common.model.v1.NameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;

public abstract class V1BaseCamelModel
extends BaseModel {
    protected V1BaseCamelModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    protected V1BaseCamelModel(String name, String namespace) {
        super(name, namespace);
    }

    protected V1BaseCamelModel(Configuration config) {
        super(config);
    }

    protected final Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    protected final Boolean getBooleanConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Boolean.valueOf(value) : null;
    }

    protected final Long getLongConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    protected final Date getDateConfig(String configName, DateFormat format) {
        String value = this.getConfig(configName);
        if (value == null) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException parseEx) {
            throw new IllegalArgumentException("Failed to parse " + configName + " as a date.", parseEx);
        }
    }

    protected final String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    protected final <T extends Enum<T>> T getEnumerationConfig(String configName, Class<T> type) {
        String constantName = this.getConfig(configName);
        if (constantName != null) {
            return Enum.valueOf(type, constantName);
        }
        return null;
    }

    protected <X extends V1BaseCamelModel> X setConfig(String name, Object value) {
        String modelValue = String.valueOf(value);
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(modelValue);
        } else {
            NameValueModel model = new NameValueModel(this.getNamespaceURI(), name);
            model.setValue(modelValue);
            this.setChildModel((Model)model);
        }
        return (X)((Object)this);
    }
}

