/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.util.URISupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.switchyard.Exchange;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.component.camel.common.SwitchYardRouteDefinition;
import org.switchyard.component.camel.common.handler.MessageComposerProcessor;
import org.switchyard.component.camel.common.handler.OperationSelectorProcessor;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.common.transaction.TransactionManagerFactory;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class InboundHandler<T extends CamelBindingModel>
extends BaseServiceHandler {
    private static TransactionManagerFactory TM_FACTORY = TransactionManagerFactory.getInstance();
    private final T _camelBindingModel;
    private final SwitchYardCamelContext _camelContext;
    private final QName _serviceName;

    public InboundHandler(T camelBindingModel, SwitchYardCamelContext camelContext, QName serviceName) {
        this._camelBindingModel = camelBindingModel;
        this._camelContext = camelContext;
        this._serviceName = serviceName;
        try {
            this._camelContext.addRouteDefinition(this.createRouteDefinition());
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    protected RouteDefinition createRouteDefinition() {
        SwitchYardRouteDefinition route = new SwitchYardRouteDefinition(this.getServiceName());
        ((RouteDefinition)route.routeId(this.getRouteId()).from(this.getComponentUri().toString()).process((Processor)new MessageComposerProcessor((CamelBindingModel)this.getBindingModel()))).process((Processor)new OperationSelectorProcessor(this.getServiceName(), (CamelBindingModel)this.getBindingModel()));
        return this.addTransactionPolicy(route);
    }

    public String getRouteId() {
        return this.getBindingModel().getClass().getSimpleName() + "/" + this.getServiceName().getLocalPart() + "@" + this.getBindingModel().getComponentURI().hashCode();
    }

    protected QName getServiceName() {
        return this._serviceName;
    }

    protected RouteDefinition addTransactionPolicy(SwitchYardRouteDefinition route) {
        if (!this.hasTransactionManager()) {
            return route.to(this.getSwitchyardEndpointUri());
        }
        String tmName = this.getTransactionManagerName();
        if (!this.isRegisteredInCamelRegistry(tmName) && this.isDefaultJtaTransactionName(tmName)) {
            PlatformTransactionManager tm = TM_FACTORY.create();
            this.addToCamelRegistry(tm, tmName);
        }
        route.transacted("transactionPolicy").to(this.getSwitchyardEndpointUri());
        SwitchYardRouteDefinition.addNamespaceParameter(route, this.getServiceName().getNamespaceURI());
        return route;
    }

    protected URI getComponentUri() {
        return this.getBindingModel().getComponentURI();
    }

    protected String getSwitchyardEndpointUri() {
        return "switchyard://" + this.getServiceName().getLocalPart();
    }

    private boolean isDefaultJtaTransactionName(String tmName) {
        return tmName.equals("jtaTransactionManager");
    }

    private boolean isRegisteredInCamelRegistry(String tmName) {
        return this._camelContext.getRegistry().lookup(tmName) != null;
    }

    private void addToCamelRegistry(PlatformTransactionManager tm, String tmName) {
        this._camelContext.getWritebleRegistry().put((Object)tmName, (Object)tm);
        this._camelContext.getWritebleRegistry().put((Object)"transactionPolicy", (Object)new SpringTransactionPolicy(tm));
    }

    protected boolean hasTransactionManager() {
        return this.getComponentUri().toString().contains("transactionManager");
    }

    protected String getTransactionManagerName() {
        try {
            Map parseParameters = URISupport.parseParameters((URI)this.getComponentUri());
            String name = (String)parseParameters.get("transactionManager");
            if (name != null) {
                name = name.replace("#", "");
            }
            return name;
        }
        catch (URISyntaxException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    protected T getBindingModel() {
        return this._camelBindingModel;
    }

    public void start() {
        try {
            RouteDefinition route = this._camelContext.getRouteDefinition(this.getRouteId());
            if (route.isStartable((CamelContext)this._camelContext)) {
                this._camelContext.startRoute(this.getRouteId());
            }
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to start route for service " + this._serviceName, (Throwable)ex);
        }
    }

    public void stop() {
        try {
            this._camelContext.stopRoute(this.getRouteId());
            this._camelContext.removeRoute(this.getRouteId());
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop route for service " + this._serviceName, (Throwable)ex);
        }
    }

    public void handleMessage(Exchange switchYardExchange) {
    }

    public void handleFault(Exchange exchange) {
        System.out.println(exchange.getMessage().getContent());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._camelBindingModel == null ? 0 : this._camelBindingModel.getComponentURI().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InboundHandler other = (InboundHandler)((Object)obj);
        return !(this._camelBindingModel == null ? other._camelBindingModel != null : !this._camelBindingModel.getComponentURI().equals(other._camelBindingModel.getComponentURI()));
    }
}

