/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.handler;

import javax.xml.namespace.QName;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.selector.OperationSelector;

public class OperationSelectorProcessor
implements Processor {
    private final QName _serviceName;
    private final CamelBindingModel _bindingModel;

    public OperationSelectorProcessor(QName serviceName, CamelBindingModel bindingModel) {
        this._serviceName = serviceName;
        this._bindingModel = bindingModel;
    }

    public void process(Exchange exchange) throws Exception {
        OperationSelectorFactory selectorFactory = OperationSelectorFactory.getOperationSelectorFactory(CamelBindingData.class);
        OperationSelector selector = selectorFactory.newOperationSelector(this._bindingModel.getOperationSelector());
        if (selector != null) {
            selector.setDefaultNamespace(Strings.trimToNull((String)this._serviceName.getNamespaceURI()));
        }
        Message in = exchange.getIn();
        in.setHeader("org.switchyard.operationSelector", (Object)selector);
        exchange.setOut(in.copy());
    }
}

