/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.composer;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.common.camel.ContextPropertyUtil;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.config.model.composer.ContextMapperModel;
import org.switchyard.config.model.composite.BindingModel;

public class CamelContextMapper
extends BaseRegexContextMapper<CamelBindingData> {
    private String[] _camelLabels = null;

    private String[] getCamelLabels() {
        if (this._camelLabels == null) {
            String e_label;
            BindingModel b_model;
            ArrayList<String> list = new ArrayList<String>();
            list.add(ComponentLabel.CAMEL.label());
            ContextMapperModel cm_model = this.getModel();
            if (cm_model != null && (b_model = cm_model.getBindingModel()) != null && (e_label = EndpointLabel.toLabel((String)b_model.getType())) != null) {
                list.add(e_label);
            }
            this._camelLabels = list.toArray(new String[list.size()]);
        }
        return this._camelLabels;
    }

    public void mapFrom(CamelBindingData source, Context context) throws Exception {
        Object value;
        String name;
        Message message = source.getMessage();
        Exchange exchange = message.getExchange();
        for (Map.Entry header : message.getHeaders().entrySet()) {
            name = (String)header.getKey();
            if (!this.matches(name) || ContextPropertyUtil.isReservedProperty((String)name, (Scope)Scope.MESSAGE) || (value = header.getValue()) == null) continue;
            context.setProperty(name, value, Scope.MESSAGE).addLabels(this.getCamelLabels());
        }
        if (exchange != null) {
            for (Map.Entry property : exchange.getProperties().entrySet()) {
                name = (String)property.getKey();
                if (!this.matches(name) || ContextPropertyUtil.isReservedProperty((String)name, (Scope)Scope.EXCHANGE) || (value = property.getValue()) == null) continue;
                context.setProperty(name, value, Scope.EXCHANGE).addLabels(this.getCamelLabels());
            }
        }
    }

    public void mapTo(Context context, CamelBindingData target) throws Exception {
        Object value;
        String name;
        Message message = target.getMessage();
        Exchange exchange = message.getExchange();
        for (Property property : context.getProperties(Scope.MESSAGE)) {
            name = property.getName();
            if (!this.matches(name) || ContextPropertyUtil.isReservedProperty((String)name, (Scope)Scope.MESSAGE) || (value = property.getValue()) == null) continue;
            message.setHeader(name, value);
        }
        if (exchange != null) {
            for (Property property : context.getProperties(Scope.EXCHANGE)) {
                name = property.getName();
                if (!this.matches(name) || ContextPropertyUtil.isReservedProperty((String)name, (Scope)Scope.EXCHANGE) || (value = property.getValue()) == null) continue;
                exchange.setProperty(name, value);
            }
        }
    }
}

