/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.composer;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.metadata.ServiceOperation;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CamelMessageComposer
extends BaseMessageComposer<CamelBindingData> {
    public Message compose(CamelBindingData source, Exchange exchange) throws Exception {
        Object content;
        Message message = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(message));
        org.apache.camel.Message sourceMessage = source.getMessage();
        QName msgType = this.getMessageType(exchange);
        if (msgType == null) {
            content = sourceMessage.getBody();
        } else if (QNameUtil.isJavaMessageType((QName)msgType)) {
            content = sourceMessage.getBody(QNameUtil.toJavaMessageType((QName)msgType));
        } else {
            content = sourceMessage.getBody();
            if (!(content instanceof String || content instanceof Node || content instanceof InputSource || content instanceof Source)) {
                content = sourceMessage.getBody(InputStream.class);
            }
        }
        message.setContent(content);
        Set attachements = sourceMessage.getAttachmentNames();
        if (!attachements.isEmpty()) {
            for (Map.Entry entry : sourceMessage.getAttachments().entrySet()) {
                message.addAttachment((String)entry.getKey(), ((DataHandler)entry.getValue()).getDataSource());
            }
        }
        return message;
    }

    public CamelBindingData decompose(Exchange exchange, CamelBindingData target) throws Exception {
        Message sourceMessage = exchange.getMessage();
        this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        org.apache.camel.Message targetMessage = target.getMessage();
        if (!sourceMessage.getAttachmentMap().isEmpty()) {
            for (Map.Entry entry : sourceMessage.getAttachmentMap().entrySet()) {
                targetMessage.addAttachment((String)entry.getKey(), new DataHandler((DataSource)entry.getValue()));
            }
        }
        ServiceOperation operation = exchange.getContract().getProviderOperation();
        targetMessage.setHeader("org.switchyard.operationName", (Object)operation.getName());
        targetMessage.setHeader("org.switchyard.faultType", (Object)operation.getFaultType());
        targetMessage.setHeader("org.switchyard.serviceName", (Object)exchange.getProvider().getName());
        targetMessage.setBody(sourceMessage.getContent());
        return target;
    }

    private QName getMessageType(Exchange exchange) {
        QName msgType = exchange.getPhase() == null ? exchange.getContract().getConsumerOperation().getInputType() : exchange.getContract().getProviderOperation().getOutputType();
        return msgType;
    }
}

