/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.handler;

import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.handler.DefaultProcessor;
import org.switchyard.component.camel.common.transaction.TransactionHelper;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class OutboundHandler
extends BaseServiceHandler {
    private static Logger _logger = Logger.getLogger(OutboundHandler.class);
    private final MessageComposer<CamelBindingData> _messageComposer;
    private final ProducerTemplate _producerTemplate;
    private final SwitchYardCamelContext _camelContext;
    private final String _uri;

    public OutboundHandler(String uri, SwitchYardCamelContext context, MessageComposer<CamelBindingData> messageComposer) {
        this(uri, context, messageComposer, null);
    }

    public OutboundHandler(String uri, SwitchYardCamelContext context, MessageComposer<CamelBindingData> messageComposer, ProducerTemplate producerTemplate) {
        if (uri == null) {
            throw new IllegalArgumentException("uri argument must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("camelContext argument must not be null");
        }
        this._uri = uri;
        this._camelContext = context;
        this._messageComposer = messageComposer;
        this._producerTemplate = producerTemplate == null ? this._camelContext.createProducerTemplate() : producerTemplate;
        TransactionHelper.useTransactionManager(this._uri, context);
    }

    public void start() {
        try {
            this._producerTemplate.start();
            _logger.debug((Object)("Started producer template for " + this._uri));
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to start Camel producer template for " + this._uri, (Throwable)e);
        }
    }

    public void stop() {
        try {
            this._producerTemplate.stop();
            _logger.debug((Object)("Stopped producer template for " + this._uri));
        }
        catch (Exception ex) {
            throw new SwitchYardException("Failed to stop Camel producer template for " + this._uri, (Throwable)ex);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (this.isInOnly(exchange)) {
            this.handleInOnly(exchange);
        } else {
            this.handleInOut(exchange);
        }
    }

    private boolean isInOnly(Exchange exchange) {
        return exchange.getContract().getConsumerOperation().getExchangePattern() == ExchangePattern.IN_ONLY;
    }

    private void handleInOnly(Exchange exchange) throws HandlerException {
        try {
            this._producerTemplate.send(this._uri, this.createProcessor(exchange));
        }
        catch (CamelExecutionException e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void handleInOut(Exchange switchyardExchange) throws HandlerException {
        org.apache.camel.Exchange camelExchange = this._producerTemplate.request(this._uri, this.createProcessor(switchyardExchange));
        Exception camelException = camelExchange.getException();
        if (!camelExchange.isFailed()) {
            this.sendResponseToSwitchyard(switchyardExchange, camelExchange.getOut().getBody());
        } else {
            QName faultName = switchyardExchange.getContract().getProviderOperation().getFaultType();
            Class declaredFault = faultName != null && QNameUtil.isJavaMessageType((QName)faultName) ? QNameUtil.toJavaMessageType((QName)faultName) : null;
            Object camelFault = camelException;
            if (camelFault == null && camelExchange.hasOut() && camelExchange.getOut().isFault()) {
                camelFault = camelExchange.getOut().getBody();
            }
            if (camelFault != null && declaredFault != null && declaredFault.isAssignableFrom(camelFault.getClass())) {
                Message msg = switchyardExchange.createMessage().setContent(camelFault);
                switchyardExchange.sendFault(msg);
            } else {
                if (camelFault instanceof Throwable) {
                    throw new HandlerException((Throwable)Throwable.class.cast(camelFault));
                }
                throw new HandlerException("camel exchange failed without an exception: " + camelFault);
            }
        }
    }

    private void sendResponseToSwitchyard(Exchange switchyardExchange, Object payload) {
        switchyardExchange.send(switchyardExchange.createMessage().setContent(payload));
    }

    private Processor createProcessor(Exchange switchyardExchange) {
        return new DefaultProcessor(this._messageComposer, switchyardExchange);
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }

    public String getUri() {
        return this._uri;
    }
}

