/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.model.v1;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.common.model.v1.NameValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public abstract class V1BaseCamelBindingModel
extends V1BindingModel
implements CamelBindingModel {
    public static final String CAMEL = "camel";
    private Configuration _environment = Configurations.newConfiguration();

    public V1BaseCamelBindingModel(String type, String namespace) {
        super(type, namespace);
    }

    public V1BaseCamelBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    public Configuration getEnvironment() {
        return this._environment;
    }

    @Override
    public void setEnvironment(Configuration config) {
        this._environment = config;
    }

    protected final void traverseConfiguration(List<Configuration> parent, QueryString queryString, String ... excludes) {
        if (parent.size() != 0) {
            ArrayList<String> excludeParameters = new ArrayList<String>(Arrays.asList(excludes));
            for (Configuration child : parent) {
                if (child != null && child.getName() != null && excludeParameters.contains(child.getName())) continue;
                if (child != null && child.getChildren().size() == 0) {
                    queryString.add(child.getName(), UnsafeUriCharactersEncoder.encode((String)child.getValue()));
                    continue;
                }
                this.traverseConfiguration(child.getChildren(), queryString, excludes);
            }
        }
    }

    protected <T extends Model> T replaceChildren(String children, T model) {
        Configuration config = this.getModelConfiguration().getFirstChild(children);
        if (config != null) {
            this.getModelConfiguration().removeChildren(children);
            this.getModelConfiguration().addChild(model.getModelConfiguration());
        } else {
            this.setChildModel(model);
        }
        return model;
    }

    protected Configuration getFirstChild(String name) {
        return this.getModelConfiguration().getFirstChild(name);
    }

    protected final Integer getIntegerConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    protected final Boolean getBooleanConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Boolean.valueOf(value) : null;
    }

    protected final Long getLongConfig(String configName) {
        String value = this.getConfig(configName);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    protected final Date getDateConfig(String configName, DateFormat format) {
        String value = this.getConfig(configName);
        if (value == null) {
            return null;
        }
        try {
            return format.parse(value);
        }
        catch (ParseException parseEx) {
            throw new IllegalArgumentException("Failed to parse " + configName + " as a date.", parseEx);
        }
    }

    protected final String getConfig(String configName) {
        Configuration config = this.getModelConfiguration().getFirstChild(configName);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    protected final <T extends Enum<T>> T getEnumerationConfig(String configName, Class<T> type) {
        String constantName = this.getConfig(configName);
        if (constantName != null) {
            return Enum.valueOf(type, constantName);
        }
        return null;
    }

    protected <X extends V1BaseCamelBindingModel> X setConfig(String name, Object value) {
        String modelValue = String.valueOf(value);
        Configuration config = this.getModelConfiguration().getFirstChild(name);
        if (config != null) {
            config.setValue(modelValue);
        } else {
            NameValueModel model = new NameValueModel(this.getNamespaceURI(), name);
            model.setValue(modelValue);
            this.setChildModel((Model)model);
        }
        return (X)this;
    }
}

