/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.switchyard.SwitchYardException;

public final class TransactionManagerFactory {
    public static final String JBOSS_USER_TRANSACTION = "java:jboss/UserTransaction";
    public static final String JBOSS_TRANSACTION_MANANGER = "java:jboss/TransactionManager";
    public static final String JBOSS_TRANSACTION_SYNC_REG = "java:jboss/TransactionSynchronizationRegistry";
    public static final String TM = "jtaTransactionManager";
    private static final TransactionManagerFactory INSTANCE = new TransactionManagerFactory();

    private TransactionManagerFactory() {
    }

    public static TransactionManagerFactory getInstance() {
        return INSTANCE;
    }

    public PlatformTransactionManager create() {
        JtaTransactionManager transactionManager = new JtaTransactionManager();
        if (this.isBound(JBOSS_USER_TRANSACTION)) {
            transactionManager.setUserTransactionName(JBOSS_USER_TRANSACTION);
            transactionManager.setTransactionManagerName(JBOSS_TRANSACTION_MANANGER);
            transactionManager.setTransactionSynchronizationRegistryName(JBOSS_TRANSACTION_SYNC_REG);
        } else if (this.isBound("java:comp/UserTransaction")) {
            transactionManager.setUserTransactionName("java:comp/UserTransaction");
        } else {
            throw new SwitchYardException("Could not create a JtaTransactionManager as no TransactionManager was found in JNDI. Tried [java:jboss/UserTransaction, java:comp/UserTransaction]");
        }
        transactionManager.afterPropertiesSet();
        return transactionManager;
    }

    private boolean isBound(String jndiName) {
        return this.lookupInJndi(jndiName) != null;
    }

    private Object lookupInJndi(String name) {
        InitialContext context = null;
        try {
            context = new InitialContext();
            Object object = context.lookup(name);
            return object;
        }
        catch (NamingException e) {
            Object var4_7 = null;
            return var4_7;
        }
        catch (Exception e) {
            throw new SwitchYardException("Unexpected Exception retrieving '" + name + "' from JNDI namespace.", (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    throw new SwitchYardException("Unexpected error closing InitialContext.", (Throwable)e);
                }
            }
        }
    }
}

