/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.transaction;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.apache.camel.util.URISupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.switchyard.SwitchYardException;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.component.camel.common.transaction.TransactionManagerFactory;

public final class TransactionHelper {
    private final SwitchYardCamelContext _context;

    private TransactionHelper(SwitchYardCamelContext context) {
        this._context = context;
    }

    private boolean isDefaultJtaTransactionName(String tmName) {
        return tmName.equals("jtaTransactionManager");
    }

    private boolean isRegisteredInCamelRegistry(String beanName) {
        return this._context.getRegistry().lookup(beanName) != null;
    }

    private void addToCamelRegistry() {
        PlatformTransactionManager transactionManager = TransactionManagerFactory.getInstance().create();
        this._context.getWritebleRegistry().put((Object)"jtaTransactionManager", (Object)transactionManager);
        this._context.getWritebleRegistry().put((Object)"transactionPolicy", (Object)new SpringTransactionPolicy(transactionManager));
    }

    private String getTransactionManagerName(URI uri) {
        try {
            Map parseParameters = URISupport.parseParameters((URI)uri);
            String name = (String)parseParameters.get("transactionManager");
            if (name != null) {
                name = name.replace("#", "");
            }
            return name;
        }
        catch (URISyntaxException e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private boolean process(URI endpointUri) {
        String transactionManagerName = this.getTransactionManagerName(endpointUri);
        if (transactionManagerName == null) {
            return false;
        }
        if (!this.isRegisteredInCamelRegistry(transactionManagerName) && this.isDefaultJtaTransactionName(transactionManagerName)) {
            this.addToCamelRegistry();
        }
        return true;
    }

    public static boolean useTransactionManager(URI endpointUri, SwitchYardCamelContext context) {
        return new TransactionHelper(context).process(endpointUri);
    }

    public static boolean useTransactionManager(String endpointUri, SwitchYardCamelContext context) {
        return TransactionHelper.useTransactionManager(URI.create(endpointUri), context);
    }
}

