/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.composer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.composer.ContextMapper;

public abstract class BaseContextMapper<T>
implements ContextMapper<T> {
    private final List<Pattern> _includes = new ArrayList<Pattern>();
    private final List<Pattern> _excludes = new ArrayList<Pattern>();
    private final List<Pattern> _includeNamespaces = new ArrayList<Pattern>();
    private final List<Pattern> _excludeNamespaces = new ArrayList<Pattern>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPatternList(String regexs, List<Pattern> patternList) {
        Set regexSet = Strings.uniqueSplitTrimToNull((String)regexs, (String)",");
        ArrayList<Pattern> tmpList = new ArrayList<Pattern>();
        for (String regex : regexSet) {
            try {
                Pattern pattern = Pattern.compile(regex);
                tmpList.add(pattern);
            }
            catch (PatternSyntaxException pse) {
                throw new IllegalArgumentException("\"" + regex + "\" is not a valid regex pattern: " + pse.getMessage());
            }
        }
        List<Pattern> list = patternList;
        synchronized (list) {
            patternList.clear();
            patternList.addAll(tmpList);
        }
    }

    @Override
    public ContextMapper<T> setIncludes(String includes) {
        this.setPatternList(includes, this._includes);
        return this;
    }

    @Override
    public ContextMapper<T> setExcludes(String excludes) {
        this.setPatternList(excludes, this._excludes);
        return this;
    }

    @Override
    public ContextMapper<T> setIncludeNamespaces(String includeNamespaces) {
        this.setPatternList(includeNamespaces, this._includeNamespaces);
        return this;
    }

    @Override
    public ContextMapper<T> setExcludeNamespaces(String excludeNamespaces) {
        this.setPatternList(excludeNamespaces, this._excludeNamespaces);
        return this;
    }

    @Override
    public boolean matches(String name) {
        return this.matches(XMLHelper.createQName((String)name));
    }

    @Override
    public boolean matches(QName qname) {
        return qname != null && this.matches(qname.getLocalPart(), this._includes, this._excludes) && this.matches(qname.getNamespaceURI(), this._includeNamespaces, this._excludeNamespaces);
    }

    private boolean matches(String test, List<Pattern> includes, List<Pattern> excludes) {
        boolean matches;
        boolean green = false;
        boolean red = false;
        for (Pattern include : includes) {
            if (include.matcher(test).matches()) {
                green = true;
                break;
            }
            red = true;
        }
        boolean bl = matches = green || !red;
        if (matches) {
            green = false;
            red = false;
            for (Pattern exclude : excludes) {
                if (!exclude.matcher(test).matches()) {
                    green = true;
                    break;
                }
                red = true;
            }
            matches = green || !red;
        }
        return matches;
    }
}

