/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.composer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.component.common.composer.ContextMapper;
import org.switchyard.config.model.composer.ContextMapperModel;

public abstract class ContextMapperFactory<T> {
    private static final Logger LOGGER = Logger.getLogger(ContextMapperFactory.class);

    public abstract Class<T> getTargetClass();

    public abstract ContextMapper<T> newContextMapperDefault();

    public final ContextMapper<T> newContextMapper(ContextMapperModel model) {
        ContextMapper<T> contextMapper = null;
        ContextMapperFactory<T> contextMapperFactory = ContextMapperFactory.getContextMapperFactory(this.getTargetClass());
        if (model != null) {
            contextMapper = contextMapperFactory.newContextMapper(model.getClazz());
            contextMapper.setIncludes(model.getIncludes());
            contextMapper.setExcludes(model.getExcludes());
            contextMapper.setIncludeNamespaces(model.getIncludeNamespaces());
            contextMapper.setExcludeNamespaces(model.getExcludeNamespaces());
        } else {
            contextMapper = contextMapperFactory.newContextMapperDefault();
        }
        return contextMapper;
    }

    public final ContextMapper<T> newContextMapper(Class<? extends ContextMapper<T>> custom) {
        ContextMapper<T> contextMapper = null;
        if (custom != null) {
            try {
                contextMapper = custom.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not instantiate ContextMapper: " + custom.getClass().getName() + " - " + e.getMessage()));
            }
        }
        if (contextMapper == null) {
            contextMapper = this.newContextMapperDefault();
        }
        return contextMapper;
    }

    public static final <F> ContextMapperFactory<F> getContextMapperFactory(Class<F> targetClass) {
        return ContextMapperFactory.getContextMapperFactories().get(targetClass);
    }

    public static final Map<Class, ContextMapperFactory> getContextMapperFactories() {
        HashMap<Class, ContextMapperFactory> factories = new HashMap<Class, ContextMapperFactory>();
        ServiceLoader<ContextMapperFactory> services = ServiceLoader.load(ContextMapperFactory.class);
        for (ContextMapperFactory factory : services) {
            factories.put(factory.getTargetClass(), factory);
        }
        return factories;
    }
}

