/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.environment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.kie.marshalling.ObjectMarshallingStrategy;
import org.switchyard.serial.Serializer;

public class SerializerObjectMarshallingStrategy
implements ObjectMarshallingStrategy {
    private static final String[] IGNORE_PKGS = new String[]{"java.", "javax.", "org.w3c.dom.", "org.jbpm.", "org.drools.", "org.kie."};
    private final Serializer _serializer;

    public SerializerObjectMarshallingStrategy(Serializer serializer) {
        this._serializer = serializer;
    }

    public boolean accept(Object object) {
        if (object != null) {
            String cn = object.getClass().getName();
            for (String ip : IGNORE_PKGS) {
                if (!cn.startsWith(ip)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        os.writeObject(this._serializer.serialize(object, Object.class));
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        return this._serializer.deserialize((byte[])os.readObject(), Object.class);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        return this._serializer.serialize(object, Object.class);
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        return this._serializer.deserialize(object, Object.class);
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

