/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.exchange;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Property;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Mappings;
import org.switchyard.component.common.knowledge.util.Resources;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.metadata.ServiceOperation;

public abstract class KnowledgeExchangeHandler<M extends KnowledgeComponentImplementationModel>
extends BaseHandler
implements ServiceHandler {
    private final M _model;
    private final ServiceDomain _domain;
    private ClassLoader _loader;
    private final Map<String, KnowledgeAction> _actions = new HashMap<String, KnowledgeAction>();
    private KnowledgeSessionFactory _sessionFactory;
    private KnowledgeSession _statefulSession;

    public KnowledgeExchangeHandler(M model, ServiceDomain domain) {
        this._model = model;
        this._domain = domain;
    }

    protected M getModel() {
        return this._model;
    }

    protected ServiceDomain getDomain() {
        return this._domain;
    }

    protected ClassLoader getLoader() {
        return this._loader;
    }

    protected Properties getPropertyOverrides() {
        return null;
    }

    protected Map<String, Object> getEnvironmentOverrides() {
        return null;
    }

    protected KnowledgeSession newStatelessSession() {
        return this._sessionFactory.newStatelessSession();
    }

    protected KnowledgeSession getStatefulSession() {
        if (this._statefulSession == null) {
            this._statefulSession = this._sessionFactory.newStatefulSession(this.getEnvironmentOverrides());
        }
        return this._statefulSession;
    }

    protected KnowledgeSession getPersistentSession(Exchange exchange, String sessionIdProperty) {
        Integer sessionId = this.getInteger(exchange, sessionIdProperty);
        if (!(this._statefulSession == null || this._statefulSession.isPersistent() && sessionId != null && sessionId.equals(this._statefulSession.getId()))) {
            this.disposeStatefulSession();
        }
        if (this._statefulSession == null) {
            this._statefulSession = this._sessionFactory.getPersistentSession(this.getEnvironmentOverrides(), sessionId);
        }
        return this._statefulSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeStatefulSession() {
        if (this._statefulSession != null) {
            try {
                this._statefulSession.dispose();
            }
            finally {
                this._statefulSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeSessionFactory() {
        if (this._sessionFactory != null) {
            try {
                this._sessionFactory.dispose();
            }
            finally {
                this._sessionFactory = null;
            }
        }
    }

    public void start() {
        this._loader = Classes.getClassLoader(((Object)((Object)this)).getClass());
        Resources.installTypes(this._loader);
        Mappings.registerActionMappings(this._model, this._actions, this.getDefaultAction());
        this._sessionFactory = KnowledgeSessionFactory.newSessionFactory(this._model, this._loader, this._domain, this.getPropertyOverrides());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._loader = null;
        this._actions.clear();
        try {
            this.disposeStatefulSession();
        }
        finally {
            this.disposeSessionFactory();
        }
    }

    public abstract KnowledgeAction getDefaultAction();

    public final void handleMessage(Exchange exchange) throws HandlerException {
        if (ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            ServiceOperation providerOperation;
            String operationName = null;
            ServiceOperation consumerOperation = exchange.getContract().getConsumerOperation();
            if (consumerOperation != null) {
                operationName = Strings.trimToNull((String)consumerOperation.getName());
            }
            if (operationName == null && (providerOperation = exchange.getContract().getProviderOperation()) != null) {
                operationName = Strings.trimToNull((String)providerOperation.getName());
            }
            KnowledgeAction action = null;
            if (operationName != null) {
                action = this._actions.get(operationName);
            }
            if (action == null) {
                action = this._actions.get("default");
            }
            this.handleAction(exchange, action);
        }
    }

    public abstract void handleAction(Exchange var1, KnowledgeAction var2) throws HandlerException;

    protected boolean isBoolean(Exchange exchange, String name) {
        Boolean b = this.getBoolean(exchange, name);
        return b != null && b != false;
    }

    protected Boolean getBoolean(Exchange exchange, String name) {
        Object value = this.getObject(exchange, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return null;
    }

    protected Integer getInteger(Exchange exchange, String name) {
        Object value = this.getObject(exchange, name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        return null;
    }

    protected Long getLong(Exchange exchange, String name) {
        Object value = this.getObject(exchange, name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        return null;
    }

    protected String getString(Exchange exchange, String name) {
        Object value = this.getObject(exchange, name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    protected Object getObject(Exchange exchange, String name) {
        Property property = exchange.getContext().getProperty(name);
        return property != null ? property.getValue() : null;
    }
}

