/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.expression;

import java.io.Serializable;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionType;

public class MVELExpression
implements Expression {
    private final String _expression;
    private Serializable _compiled;

    public MVELExpression(String expression) {
        this._expression = expression;
        this.compile();
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.MVEL;
    }

    private void compile() {
        ParserContext pc = new ParserContext();
        pc.addPackageImport("org.switchyard");
        this._compiled = MVEL.compileExpression((String)this._expression, (ParserContext)pc);
    }

    @Override
    public boolean isCompiled() {
        return this._compiled != null;
    }

    @Override
    public Object evaluate() {
        return this.isCompiled() ? MVEL.executeExpression((Object)this._compiled) : MVEL.eval((String)this._expression);
    }

    @Override
    public Object evaluate(Object context) {
        return this.isCompiled() ? MVEL.executeExpression((Object)this._compiled, (Object)context) : MVEL.eval((String)this._expression, (Object)context);
    }
}

