/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.switchyard.component.common.knowledge.config.model.v1;

import static org.switchyard.component.common.knowledge.config.model.MappingModel.MAPPING;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import org.switchyard.component.common.knowledge.config.model.MappingModel;
import org.switchyard.component.common.knowledge.config.model.MappingsModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseModel;
import org.switchyard.config.model.Descriptor;

/**
 * A version 1 MappingsModel.
 *
 * @author David Ward &lt;<a href="mailto:dward@jboss.org">dward@jboss.org</a>&gt; &copy; 2012 Red Hat Inc.
 */
public class V1MappingsModel extends BaseModel implements MappingsModel {

    private List<MappingModel> _mappings = new ArrayList<MappingModel>();

    /**
     * Creates a new MappingsModel in the specified namespace.
     * @param namespace the specified namespace
     */
    public V1MappingsModel(String namespace) {
        this(namespace, MAPPINGS);
    }

    /**
     * Creates a new MappingsModel in the specified namespace and localName.
     * @param namespace the specified namespace
     * @param localName the specified localName
     */
    public V1MappingsModel(String namespace, String localName) {
        super(new QName(namespace, localName));
        setModelChildrenOrder(MAPPING);
    }

    /**
     * Creates a new MappingsModel with the specified configuration and descriptor.
     * @param config the configuration
     * @param desc the descriptor
     */
    public V1MappingsModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration mapping_config : config.getChildren(MAPPING)) {
            MappingModel mapping = (MappingModel)readModel(mapping_config);
            if (mapping != null) {
                _mappings.add(mapping);
            }
        }
        setModelChildrenOrder(MAPPING);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public synchronized List<MappingModel> getMappings() {
        return Collections.unmodifiableList(_mappings);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MappingsModel addMapping(MappingModel mapping) {
        addChildModel(mapping);
        _mappings.add(mapping);
        return this;
    }

}
