/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.expression;

import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.component.common.knowledge.config.model.MappingModel;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionType;
import org.switchyard.component.common.knowledge.expression.MVELExpression;

public final class ExpressionFactory {
    private static final ExpressionFactory INSTANCE = new ExpressionFactory();

    private ExpressionFactory() {
    }

    public Expression create(String expression, ExpressionType expressionType) {
        return this.create(expression, expressionType, null);
    }

    public Expression create(String expression, ExpressionType expressionType, PropertyResolver propertyResolver) {
        if (propertyResolver == null) {
            propertyResolver = SystemAndTestPropertyResolver.instance();
        }
        switch (expressionType) {
            case MVEL: {
                return new MVELExpression(expression, propertyResolver);
            }
        }
        throw new IllegalArgumentException("Unknown expressionType: " + (Object)((Object)expressionType));
    }

    public Expression create(MappingModel mappingModel) {
        ExpressionType expressionType = mappingModel.getExpressionType();
        if (expressionType == null) {
            expressionType = ExpressionType.MVEL;
        }
        return this.create(mappingModel.getExpression(), expressionType, mappingModel.getModelConfiguration().getPropertyResolver());
    }

    public static ExpressionFactory instance() {
        return INSTANCE;
    }
}

