/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.service;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceRequest;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceResponse;
import org.switchyard.exception.SwitchYardException;

public class SwitchYardServiceInvoker {
    private final ServiceDomain _serviceDomain;
    private final String _targetNamespace;

    public SwitchYardServiceInvoker(ServiceDomain serviceDomain) {
        this(serviceDomain, null);
    }

    public SwitchYardServiceInvoker(ServiceDomain serviceDomain, String targetNamespace) {
        this._serviceDomain = serviceDomain;
        this._targetNamespace = targetNamespace;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public SwitchYardServiceResponse invoke(SwitchYardServiceRequest request) {
        HashMap<String, Object> contextOut = new HashMap<String, Object>();
        Object contentOutput = null;
        Object fault = null;
        try {
            ServiceDomain serviceDomain;
            String tns;
            QName serviceName = request.getServiceName();
            if (serviceName == null) {
                throw new SwitchYardException("ServiceName == null");
            }
            if (Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
                serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
            }
            if ((serviceDomain = this.getServiceDomain()) == null) {
                throw new SwitchYardException("ServiceDomain == null");
            }
            ServiceReference serviceReference = serviceDomain.getServiceReference(serviceName);
            if (serviceReference == null) {
                throw new SwitchYardException("ServiceReference [" + serviceName + "] == null");
            }
            FaultHandler handler = new FaultHandler();
            String serviceOperationName = request.getServiceOperationName();
            Exchange exchangeIn = serviceOperationName != null ? serviceReference.createExchange(serviceOperationName, (ExchangeHandler)handler) : serviceReference.createExchange((ExchangeHandler)handler);
            Context contextIn = exchangeIn.getContext();
            for (Map.Entry<String, Object> entry : request.getContext().entrySet()) {
                contextIn.setProperty(entry.getKey(), entry.getValue(), Scope.IN);
            }
            Message messageIn = exchangeIn.createMessage();
            Object contentInput = request.getContent();
            if (contentInput != null) {
                messageIn.setContent(contentInput);
            }
            exchangeIn.send(messageIn);
            if (ExchangePattern.IN_OUT.equals((Object)exchangeIn.getContract().getConsumerOperation().getExchangePattern())) {
                Exchange exchangeOut = handler.waitForOut();
                Message messageOut = exchangeOut.getMessage();
                contentOutput = messageOut.getContent();
                for (Property property : exchangeOut.getContext().getProperties(Scope.OUT)) {
                    contextOut.put(property.getName(), property.getValue());
                }
            }
            fault = handler.getFault();
        }
        catch (Throwable t) {
            fault = t;
        }
        return new SwitchYardServiceResponse(contentOutput, contextOut, fault);
    }

    private static final class FaultHandler
    extends SynchronousInOutHandler {
        private Object _fault;

        private FaultHandler() {
        }

        private Object getFault() {
            return this._fault;
        }

        public void handleFault(Exchange exchange) {
            this._fault = exchange.getMessage().getContent();
            super.handleFault(exchange);
        }
    }
}

