/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.lang.reflect.Constructor;
import java.util.EventListener;
import org.drools.RuleBase;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.reteoo.ReteooWorkingMemoryInterface;
import org.drools.runtime.process.InternalProcessRuntime;
import org.kie.event.KieRuntimeEventManager;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.event.kiebase.KieBaseEventListener;
import org.kie.event.process.ProcessEventListener;
import org.kie.event.rule.AgendaEventListener;
import org.kie.event.rule.DefaultAgendaEventListener;
import org.kie.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.runtime.KieRuntime;
import org.kie.runtime.KieSession;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ListenerModel;
import org.switchyard.component.common.knowledge.config.model.ListenersModel;
import org.switchyard.exception.SwitchYardException;

public final class Listeners {
    private static final Class<?>[][] PARMAMETER_TYPES = new Class[][]{{KieRuntimeEventManager.class}, {KieRuntime.class}, {KnowledgeRuntimeEventManager.class}, {KnowledgeRuntime.class}, new Class[0]};

    public static void registerListeners(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager) {
        ListenersModel listenersModel;
        if (runtimeEventManager instanceof StatefulKnowledgeSession) {
            runtimeEventManager.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                    ((KieSession)event.getKieRuntime()).fireAllRules();
                }
            });
        }
        if ((listenersModel = model.getListeners()) != null) {
            for (ListenerModel listenerModel : listenersModel.getListeners()) {
                Class<?> listenerClass = listenerModel.getClazz(loader);
                if (listenerClass == null) {
                    throw new SwitchYardException("Could not load listener class: " + listenerModel.getModelConfiguration().getAttribute("class"));
                }
                Listeners.registerListener(listenerClass, runtimeEventManager);
            }
        }
    }

    private static void registerListener(Class<? extends EventListener> listenerClass, KieRuntimeEventManager runtimeEventManager) {
        Constructor<? extends EventListener> constructor = Listeners.getConstructor(listenerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                EventListener listener = (EventListener)Construction.construct(listenerClass);
                Listeners.registerListener(listener, runtimeEventManager);
            } else if (parameterTypes.length == 1) {
                EventListener listener = (EventListener)Construction.construct(listenerClass, (Class[])parameterTypes, (Object[])new Object[]{runtimeEventManager});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate listener class: " + listenerClass.getName());
        }
    }

    private static Constructor<? extends EventListener> getConstructor(Class<? extends EventListener> listenerClass) {
        Constructor<? extends EventListener> constructor = null;
        for (Class<?>[] parameterTypes : PARMAMETER_TYPES) {
            try {
                constructor = listenerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    private static void registerListener(EventListener listener, KieRuntimeEventManager runtimeEventManager) {
        if (runtimeEventManager instanceof StatefulKnowledgeSessionImpl) {
            InternalProcessRuntime processRuntime;
            StatefulKnowledgeSessionImpl sksi = (StatefulKnowledgeSessionImpl)runtimeEventManager;
            ReteooWorkingMemoryInterface wmem = sksi.session;
            if (listener instanceof WorkingMemoryEventListener) {
                wmem.addEventListener((WorkingMemoryEventListener)listener);
            } else if (listener instanceof org.kie.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.event.AgendaEventListener) {
                wmem.addEventListener((org.drools.event.AgendaEventListener)listener);
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                wmem.addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                sksi.getKieBase().addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener && (processRuntime = sksi.session.getProcessRuntime()) != null) {
                processRuntime.addEventListener((ProcessEventListener)listener);
            }
        } else if (runtimeEventManager instanceof StatelessKnowledgeSessionImpl) {
            StatelessKnowledgeSessionImpl sksi = (StatelessKnowledgeSessionImpl)runtimeEventManager;
            if (listener instanceof WorkingMemoryEventListener) {
                sksi.workingMemoryEventSupport.addEventListener((EventListener)((WorkingMemoryEventListener)listener));
            } else if (listener instanceof org.kie.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.event.AgendaEventListener) {
                sksi.agendaEventSupport.addEventListener((EventListener)((org.drools.event.AgendaEventListener)listener));
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                sksi.getRuleBase().addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                new KnowledgeBaseImpl((RuleBase)sksi.getRuleBase()).addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener) {
                sksi.processEventSupport.addEventListener((EventListener)((ProcessEventListener)listener));
            }
        } else if (runtimeEventManager instanceof CommandBasedStatefulKnowledgeSession) {
            InternalProcessRuntime ipr;
            CommandBasedStatefulKnowledgeSession cbsks = (CommandBasedStatefulKnowledgeSession)runtimeEventManager;
            ReteooWorkingMemoryInterface rwmi = ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)cbsks.getCommandService().getContext()).getStatefulKnowledgesession()).session;
            if (listener instanceof WorkingMemoryEventListener) {
                rwmi.addEventListener((WorkingMemoryEventListener)listener);
            } else if (listener instanceof org.kie.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.event.AgendaEventListener) {
                rwmi.addEventListener((org.drools.event.AgendaEventListener)listener);
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                rwmi.addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                cbsks.getKieBase().addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener && (ipr = rwmi.getProcessRuntime()) != null) {
                ipr.addEventListener((ProcessEventListener)listener);
            }
        }
    }

    private Listeners() {
    }
}

