/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.runtime.Globals;
import org.switchyard.Exchange;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.ActionType;
import org.switchyard.component.common.knowledge.config.model.ActionModel;
import org.switchyard.component.common.knowledge.config.model.ActionsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.MappingModel;
import org.switchyard.component.common.knowledge.config.model.MappingsModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.expression.ContextMap;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionFactory;
import org.switchyard.component.common.knowledge.expression.ExpressionMapping;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.exception.SwitchYardException;

public final class Mappings {
    public static void registerActionMappings(KnowledgeComponentImplementationModel model, Map<String, KnowledgeAction> actions, KnowledgeAction defaultAction) {
        ActionsModel actionsModel = model.getActions();
        if (actionsModel != null) {
            for (ActionModel actionModel : actionsModel.getActions()) {
                ActionType type;
                String id;
                String operation = Strings.trimToNull((String)actionModel.getOperation());
                if (operation == null) {
                    operation = "default";
                }
                if ((id = actionModel.getId()) == null) {
                    id = defaultAction.getId();
                }
                if ((type = actionModel.getType()) == null) {
                    type = defaultAction.getType();
                }
                KnowledgeAction action = new KnowledgeAction(id, type);
                Mappings.registerExpressionMappings(actionModel.getGlobals(), action.getGlobalExpressionMappings(), Scope.EXCHANGE);
                Mappings.registerExpressionMappings(actionModel.getInputs(), action.getInputExpressionMappings(), Scope.IN);
                Mappings.registerExpressionMappings(actionModel.getOutputs(), action.getOutputExpressionMappings(), Scope.OUT);
                if (actions.containsKey(operation)) {
                    throw new SwitchYardException(String.format("cannot register %s action due to duplicate operation: %s", type, operation));
                }
                actions.put(operation, action);
            }
        }
        if (!actions.containsKey("default")) {
            actions.put("default", defaultAction);
        }
    }

    private static void registerExpressionMappings(MappingsModel mappingsModel, List<ExpressionMapping> expressionMappings, Scope defaultScope) {
        if (mappingsModel != null) {
            ExpressionFactory expressionFactory = ExpressionFactory.instance();
            for (MappingModel mappingModel : mappingsModel.getMappings()) {
                Expression expression = expressionFactory.create(mappingModel);
                Scope scope = mappingModel.getScope();
                if (scope == null) {
                    scope = defaultScope;
                }
                String variable = mappingModel.getVariable();
                expressionMappings.add(new ExpressionMapping(expression, scope, variable));
            }
        }
    }

    public static void setGlobals(Exchange exchange, KnowledgeAction action, KnowledgeSession session, boolean includeTrifecta) {
        Globals globals = session.getGlobals();
        if (includeTrifecta) {
            globals.set("exchange", (Object)exchange);
            globals.set("context", (Object)exchange.getContext());
            globals.set("message", (Object)exchange.getMessage());
        }
        Map<String, Object> map = Mappings.getGlobalMap(exchange, action);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            globals.set(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, Object> getGlobalMap(Exchange exchange, KnowledgeAction action) {
        return Mappings.getMap(exchange, action.getGlobalExpressionMappings());
    }

    public static Map<String, Object> getInputMap(Exchange exchange, KnowledgeAction action) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ExpressionMapping> inputs = action.getInputExpressionMappings();
        if (inputs.size() > 0) {
            map.putAll(Mappings.getMap(exchange, inputs));
        } else {
            Object content = exchange.getMessage().getContent();
            if (content != null) {
                map.put("contentInput", content);
            }
        }
        return map;
    }

    public static Map<String, Object> getOutputMap(Exchange exchange, KnowledgeAction action) {
        return Mappings.getOutputMap(exchange, action, null);
    }

    public static Map<String, Object> getOutputMap(Exchange exchange, KnowledgeAction action, Map<String, Object> contextOverrides) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ExpressionMapping> outputs = action.getOutputExpressionMappings();
        if (outputs.size() > 0) {
            map.putAll(Mappings.getMap(exchange, outputs, contextOverrides));
        } else {
            Object content = null;
            if (contextOverrides != null) {
                content = contextOverrides.get("contentOutput");
            }
            if (content == null) {
                content = exchange.getMessage().getContent();
            }
            if (content != null) {
                map.put("contentOutput", content);
            }
        }
        return map;
    }

    public static List<Object> getInputList(Exchange exchange, KnowledgeAction action) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<ExpressionMapping> inputs = action.getInputExpressionMappings();
        if (inputs.size() > 0) {
            list.addAll(Mappings.getList(exchange, inputs));
        } else {
            Mappings.expand(exchange.getMessage().getContent(), list);
        }
        return list;
    }

    public static List<Object> getOutputList(Exchange exchange, KnowledgeAction action) {
        return Mappings.getList(exchange, action.getOutputExpressionMappings());
    }

    public static Object getOutput(Exchange exchange, KnowledgeAction action) {
        List<Object> list = Mappings.getOutputList(exchange, action);
        switch (list.size()) {
            case 0: {
                return exchange.getMessage().getContent();
            }
            case 1: {
                return list.get(0);
            }
        }
        return list;
    }

    private static Map<String, Object> getMap(Exchange exchange, List<ExpressionMapping> mappings) {
        return Mappings.getMap(exchange, mappings, null);
    }

    private static Map<String, Object> getMap(Exchange exchange, List<ExpressionMapping> mappings, Map<String, Object> contextOverrides) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, List<Object>> listMap = Mappings.getListMap(exchange, mappings, false, Mappings.toVariable(exchange), contextOverrides);
        for (Map.Entry<String, List<Object>> entry : listMap.entrySet()) {
            List<Object> list = entry.getValue();
            map.put(entry.getKey(), list != null && list.size() > 0 ? list.get(0) : null);
        }
        return map;
    }

    private static List<Object> getList(Exchange exchange, List<ExpressionMapping> mappings) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (mappings == null || mappings.size() == 0) {
            Mappings.expand(exchange.getMessage().getContent(), list);
        } else {
            Map<String, List<Object>> listMap = Mappings.getListMap(exchange, mappings, true, Mappings.toVariable(exchange));
            for (List<Object> value : listMap.values()) {
                Mappings.expand(value, list);
            }
        }
        return list;
    }

    public static Map<String, List<Object>> getListMap(Exchange exchange, List<ExpressionMapping> mappings, boolean expand, String undefinedVariable) {
        return Mappings.getListMap(exchange, mappings, expand, undefinedVariable, null);
    }

    public static Map<String, List<Object>> getListMap(Exchange exchange, List<ExpressionMapping> mappings, boolean expand, String undefinedVariable, Map<String, Object> contextOverrides) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (mappings != null) {
            for (ExpressionMapping em : mappings) {
                String var = Strings.trimToNull((String)em.getVariable());
                if (var == null && undefinedVariable != null) {
                    var = undefinedVariable;
                }
                if (var == null) continue;
                ArrayList<Object> list = (ArrayList<Object>)map.get(var);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(var, list);
                }
                HashMap<String, Object> ctx = new HashMap<String, Object>();
                ctx.put("exchange", exchange);
                ctx.put("context", new ContextMap(exchange.getContext(), em.getScope()));
                ctx.put("message", exchange.getMessage());
                if (contextOverrides != null) {
                    for (Map.Entry<String, Object> contextOverride : contextOverrides.entrySet()) {
                        ctx.put(contextOverride.getKey(), contextOverride.getValue());
                    }
                }
                Object value = em.getExpression().evaluate(ctx);
                if (expand) {
                    Mappings.expand(value, list);
                    continue;
                }
                if (value == null) continue;
                list.add(value);
            }
        }
        return map;
    }

    private static void expand(Object value, List<Object> list) {
        if (value != null) {
            if (value instanceof Iterable) {
                for (Object o : (Iterable)value) {
                    if (o == null) continue;
                    list.add(o);
                }
            } else {
                list.add(value);
            }
        }
    }

    public static String toVariable(Object object) {
        return "$_" + System.identityHashCode(object);
    }

    private Mappings() {
    }
}

