/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposer;
import org.switchyard.component.common.knowledge.util.Disposals;

public class KnowledgeSession
extends KnowledgeDisposer {
    private final StatelessKieSession _stateless;
    private final KieSession _stateful;
    private final boolean _persistent;

    public KnowledgeSession(StatelessKieSession stateless, KnowledgeDisposal ... disposals) {
        this._stateless = stateless;
        this._stateful = null;
        this._persistent = false;
        this.addDisposals(disposals);
    }

    public KnowledgeSession(KieSession stateful, boolean persistent, KnowledgeDisposal ... disposals) {
        this._stateless = null;
        this._stateful = stateful;
        this._persistent = persistent;
        this.addDisposals(disposals);
        this.addDisposals(Disposals.newDisposal(this._stateful));
    }

    public boolean isStateless() {
        return this._stateless != null;
    }

    public boolean isStateful() {
        return this._stateful != null;
    }

    public boolean isPersistent() {
        return this.isStateful() && this._persistent;
    }

    public StatelessKieSession getStateless() {
        return this._stateless;
    }

    public KieSession getStateful() {
        return this._stateful;
    }

    public Integer getId() {
        if (this.isStateful()) {
            return this.getStateful().getId();
        }
        return null;
    }

    public Globals getGlobals() {
        if (this.isStateless()) {
            return this.getStateless().getGlobals();
        }
        if (this.isStateful()) {
            return this.getStateful().getGlobals();
        }
        return null;
    }
}

