/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.expression;

import org.switchyard.common.lang.Strings;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.common.property.SystemAndTestPropertyResolver;
import org.switchyard.component.common.knowledge.config.model.MappingModel;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionFactory;

public final class ExpressionMapping {
    private final PropertyResolver _propertyResolver;
    private final String _from;
    private final String _to;
    private Expression _fromExpression = null;
    private Expression _toExpression = null;

    public ExpressionMapping(MappingModel mappingModel) {
        PropertyResolver propertyResolver = mappingModel.getModelConfiguration().getPropertyResolver();
        this._propertyResolver = propertyResolver != null ? propertyResolver : SystemAndTestPropertyResolver.INSTANCE;
        this._from = Strings.trimToNull((String)mappingModel.getFrom());
        this._to = Strings.trimToNull((String)mappingModel.getTo());
    }

    public PropertyResolver getPropertyResolver() {
        return this._propertyResolver;
    }

    public String getFrom() {
        return this._from;
    }

    public Expression getFromExpression() {
        if (this._fromExpression == null && this._from != null) {
            this._fromExpression = ExpressionFactory.INSTANCE.create(this._from, null, this._propertyResolver);
        }
        return this._fromExpression;
    }

    public String getTo() {
        return this._to;
    }

    public Expression getToExpression() {
        if (this._toExpression == null && this._to != null) {
            this._toExpression = ExpressionFactory.INSTANCE.create(this._to, null, this._propertyResolver);
        }
        return this._toExpression;
    }
}

