/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;

public class KnowledgeDisposer
implements KnowledgeDisposal {
    private static Logger LOGGER = Logger.getLogger(KnowledgeDisposer.class);
    private final Set<KnowledgeDisposal> _disposals = new LinkedHashSet<KnowledgeDisposal>();

    public void addDisposals(KnowledgeDisposal ... disposals) {
        if (disposals != null) {
            for (KnowledgeDisposal disposal : disposals) {
                if (disposal == null) continue;
                this._disposals.add(disposal);
            }
        }
    }

    @Override
    public void dispose() {
        for (KnowledgeDisposal disposal : this._disposals) {
            try {
                disposal.dispose();
            }
            catch (Throwable t) {
                LOGGER.warn((Object)String.format("problem disposing [%s]: %s", disposal.getClass().getSimpleName(), t.getMessage()));
            }
        }
        this._disposals.clear();
    }
}

