/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.log4j.Logger;
import org.kie.api.builder.KieScanner;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.kie.internal.agent.KnowledgeAgent;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;

public final class Disposals {
    private static final Logger LOGGER = Logger.getLogger(Disposals.class);

    public static KnowledgeDisposal newDisposal(final EntityManagerFactory entityManagerFactory) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                try {
                    if (entityManagerFactory != null) {
                        entityManagerFactory.close();
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)("problem closing EntityManagerFactory: " + t.getMessage()));
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final List<KieRuntimeLogger> kieRuntimeLoggers) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                if (kieRuntimeLoggers != null) {
                    for (KieRuntimeLogger kieRuntimeLogger : kieRuntimeLoggers) {
                        try {
                            if (kieRuntimeLogger == null) continue;
                            kieRuntimeLogger.close();
                        }
                        catch (Throwable t) {
                            LOGGER.warn((Object)("problem closing KieRuntimeLogger: " + t.getMessage()));
                        }
                    }
                    kieRuntimeLoggers.clear();
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final KieScanner kieScanner) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                try {
                    if (kieScanner != null) {
                        kieScanner.stop();
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)("problem stoppping KieScanner: " + t.getMessage()));
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final KieSession kieSession) {
        return new KnowledgeDisposal(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                block5: {
                    try {
                        if (kieSession == null) break block5;
                        try {
                            kieSession.halt();
                        }
                        finally {
                            kieSession.dispose();
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.warn((Object)("problem disposing KieSession: " + t.getMessage()));
                    }
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final KnowledgeAgent knowledgeAgent) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                try {
                    if (knowledgeAgent != null) {
                        knowledgeAgent.dispose();
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)("problem disposing KnowledgeAgent: " + t.getMessage()));
                }
            }
        };
    }

    private Disposals() {
    }
}

