/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.lang.reflect.Constructor;
import java.util.EventListener;
import org.drools.core.RuleBase;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ListenerModel;
import org.switchyard.component.common.knowledge.config.model.ListenersModel;

public final class Listeners {
    private static final Class<?>[][] PARMAMETER_TYPES = new Class[][]{{KieRuntimeEventManager.class}, {KieRuntime.class}, {KnowledgeRuntimeEventManager.class}, {KnowledgeRuntime.class}, new Class[0]};

    public static void registerListeners(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager) {
        ListenersModel listenersModel;
        if (runtimeEventManager instanceof StatefulKnowledgeSession) {
            runtimeEventManager.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                    ((KieSession)event.getKieRuntime()).fireAllRules();
                }
            });
        }
        if ((listenersModel = model.getListeners()) != null) {
            for (ListenerModel listenerModel : listenersModel.getListeners()) {
                Class<?> listenerClass = listenerModel.getClazz(loader);
                if (listenerClass == null) {
                    throw new SwitchYardException("Could not load listener class: " + listenerModel.getModelConfiguration().getAttribute("class"));
                }
                Listeners.registerListener(listenerClass, runtimeEventManager);
            }
        }
    }

    private static void registerListener(Class<? extends EventListener> listenerClass, KieRuntimeEventManager runtimeEventManager) {
        Constructor<? extends EventListener> constructor = Listeners.getConstructor(listenerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                EventListener listener = (EventListener)Construction.construct(listenerClass);
                Listeners.registerListener(listener, runtimeEventManager);
            } else if (parameterTypes.length == 1) {
                EventListener listener = (EventListener)Construction.construct(listenerClass, (Class[])parameterTypes, (Object[])new Object[]{runtimeEventManager});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate listener class: " + listenerClass.getName());
        }
    }

    private static Constructor<? extends EventListener> getConstructor(Class<? extends EventListener> listenerClass) {
        Constructor<? extends EventListener> constructor = null;
        for (Class<?>[] parameterTypes : PARMAMETER_TYPES) {
            try {
                constructor = listenerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    public static void registerListener(EventListener listener, KieRuntimeEventManager runtimeEventManager) {
        if (runtimeEventManager instanceof StatefulKnowledgeSessionImpl) {
            InternalProcessRuntime processRuntime;
            StatefulKnowledgeSessionImpl sksi = (StatefulKnowledgeSessionImpl)runtimeEventManager;
            ReteooWorkingMemoryInterface wmem = sksi.session;
            if (listener instanceof WorkingMemoryEventListener) {
                wmem.addEventListener((WorkingMemoryEventListener)listener);
            } else if (listener instanceof org.kie.api.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.api.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.core.event.AgendaEventListener) {
                wmem.addEventListener((org.drools.core.event.AgendaEventListener)listener);
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                wmem.addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                sksi.getKieBase().addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener && (processRuntime = sksi.session.getProcessRuntime()) != null) {
                processRuntime.addEventListener((ProcessEventListener)listener);
            }
        } else if (runtimeEventManager instanceof StatelessKnowledgeSessionImpl) {
            StatelessKnowledgeSessionImpl sksi = (StatelessKnowledgeSessionImpl)runtimeEventManager;
            if (listener instanceof WorkingMemoryEventListener) {
                sksi.workingMemoryEventSupport.addEventListener((EventListener)((WorkingMemoryEventListener)listener));
            } else if (listener instanceof org.kie.api.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.api.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.core.event.AgendaEventListener) {
                sksi.agendaEventSupport.addEventListener((EventListener)((org.drools.core.event.AgendaEventListener)listener));
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                sksi.getRuleBase().addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                new KnowledgeBaseImpl((RuleBase)sksi.getRuleBase()).addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener) {
                sksi.processEventSupport.addEventListener((EventListener)((ProcessEventListener)listener));
            }
        } else if (runtimeEventManager instanceof CommandBasedStatefulKnowledgeSession) {
            InternalProcessRuntime ipr;
            CommandBasedStatefulKnowledgeSession cbsks = (CommandBasedStatefulKnowledgeSession)runtimeEventManager;
            ReteooWorkingMemoryInterface rwmi = ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)cbsks.getCommandService().getContext()).getKieSession()).session;
            if (listener instanceof WorkingMemoryEventListener) {
                rwmi.addEventListener((WorkingMemoryEventListener)listener);
            } else if (listener instanceof org.kie.api.event.rule.WorkingMemoryEventListener) {
                runtimeEventManager.addEventListener((org.kie.api.event.rule.WorkingMemoryEventListener)listener);
            }
            if (listener instanceof org.drools.core.event.AgendaEventListener) {
                rwmi.addEventListener((org.drools.core.event.AgendaEventListener)listener);
            } else if (listener instanceof AgendaEventListener) {
                runtimeEventManager.addEventListener((AgendaEventListener)listener);
            }
            if (listener instanceof RuleBaseEventListener) {
                rwmi.addEventListener((RuleBaseEventListener)listener);
            } else if (listener instanceof KieBaseEventListener) {
                cbsks.getKieBase().addEventListener((KieBaseEventListener)listener);
            }
            if (listener instanceof ProcessEventListener && (ipr = rwmi.getProcessRuntime()) != null) {
                ipr.addEventListener((ProcessEventListener)listener);
            }
        }
    }

    private Listeners() {
    }
}

