/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Channels;
import org.switchyard.component.common.knowledge.util.Configurations;
import org.switchyard.component.common.knowledge.util.Containers;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Listeners;
import org.switchyard.component.common.knowledge.util.Loggers;
import org.switchyard.component.common.knowledge.util.Resources;

class KnowledgeBuilderSessionFactory
extends KnowledgeSessionFactory {
    private static final AtomicInteger VERSION_COUNT;
    private static final String LINE_SEPARATOR;
    private final KieBase _base = this.newBase();
    private final KieSessionConfiguration _sessionConfiguration = Configurations.getSessionConfiguration(this.getModel(), this.getLoader(), this.getPropertyOverrides());

    KnowledgeBuilderSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        super(model, loader, domain, propertyOverrides);
    }

    @Override
    public KnowledgeSession newStatelessSession() {
        StatelessKieSession stateless = this._base.newStatelessKieSession(this._sessionConfiguration);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateless);
        return new KnowledgeSession(stateless, loggersDisposal);
    }

    @Override
    public KnowledgeSession newStatefulSession(Map<String, Object> environmentOverrides) {
        Environment env = Environments.getEnvironment(environmentOverrides);
        KieSession stateful = this._base.newKieSession(this._sessionConfiguration, env);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateful);
        return new KnowledgeSession(stateful, false, loggersDisposal);
    }

    @Override
    public KnowledgeSession getPersistentSession(Map<String, Object> environmentOverrides, Integer sessionId) {
        KieStoreServices kieStoreServices = KieServices.Factory.get().getStoreServices();
        Environment env = Environments.getEnvironment(environmentOverrides);
        KieSession stateful = null;
        if (sessionId != null) {
            stateful = kieStoreServices.loadKieSession(sessionId.intValue(), this._base, this._sessionConfiguration, env);
        }
        if (stateful == null) {
            stateful = kieStoreServices.newKieSession(this._base, this._sessionConfiguration, env);
        }
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateful);
        return new KnowledgeSession(stateful, true, loggersDisposal);
    }

    private KieBase newBase() {
        KieServices kieServices = KieServices.Factory.get();
        ReleaseId releaseId = Containers.toReleaseId("org.switchyard.tmp", "app", String.valueOf(VERSION_COUNT.incrementAndGet()));
        KieFileSystem kieFileSystem = kieServices.newKieFileSystem().generateAndWritePomXML(releaseId);
        Resources.addResources(this.getModel(), this.getLoader(), kieFileSystem);
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem).buildAll();
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            StringBuilder sb = new StringBuilder(CommonKnowledgeMessages.MESSAGES.problemBuildingKnowledge());
            for (Message message : results.getMessages(new Message.Level[]{Message.Level.ERROR})) {
                sb.append(LINE_SEPARATOR);
                sb.append(message.toString().trim());
            }
            throw new SwitchYardException(sb.toString());
        }
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieBaseConfiguration kieBaseConfiguration = Configurations.getBaseConfiguration(this.getModel(), this.getLoader(), this.getPropertyOverrides());
        return kieContainer.newKieBase(kieBaseConfiguration);
    }

    static {
        String lineSeparator;
        VERSION_COUNT = new AtomicInteger();
        try {
            lineSeparator = System.getProperty("line.separator", "\n");
        }
        catch (Throwable t) {
            lineSeparator = "\n";
        }
        LINE_SEPARATOR = lineSeparator;
    }
}

