/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;

public class KnowledgeDisposer
implements KnowledgeDisposal {
    private final Set<KnowledgeDisposal> _disposals = Collections.synchronizedSet(new LinkedHashSet());

    public synchronized void addDisposals(KnowledgeDisposal ... disposals) {
        if (disposals != null) {
            for (KnowledgeDisposal disposal : disposals) {
                if (disposal == null || disposal == this) continue;
                this._disposals.add(disposal);
            }
        }
    }

    @Override
    public synchronized void dispose() {
        for (KnowledgeDisposal disposal : this._disposals) {
            try {
                disposal.dispose();
            }
            catch (Throwable t) {
                CommonKnowledgeLogger.ROOT_LOGGER.problemDisposing(disposal.getClass().getSimpleName(), t.getMessage());
            }
        }
        this._disposals.clear();
    }
}

