/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.lang.reflect.Constructor;
import java.util.EventListener;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ListenerModel;
import org.switchyard.component.common.knowledge.config.model.ListenersModel;

public final class Listeners {
    private static final Class<?>[][] PARMAMETER_TYPES = new Class[][]{{KieRuntimeEventManager.class}, {KieRuntime.class}, new Class[0]};

    public static void registerListeners(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager manager) {
        ListenersModel listenersModel;
        if (manager instanceof KieSession) {
            manager.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                public void matchCreated(MatchCreatedEvent event) {
                    ((KieSession)event.getKieRuntime()).fireAllRules();
                }

                public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                    ((KieSession)event.getKieRuntime()).fireAllRules();
                }
            });
        }
        if ((listenersModel = model.getListeners()) != null) {
            for (ListenerModel listenerModel : listenersModel.getListeners()) {
                Class<?> listenerClass = listenerModel.getClazz(loader);
                if (listenerClass == null) {
                    throw CommonKnowledgeMessages.MESSAGES.couldNotLoadListenerClass(listenerModel.getModelConfiguration().getAttribute("class"));
                }
                Listeners.registerListener(listenerClass, manager);
            }
        }
    }

    private static void registerListener(Class<? extends EventListener> listenerClass, KieRuntimeEventManager manager) {
        Constructor<? extends EventListener> constructor = Listeners.getConstructor(listenerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                EventListener listener = (EventListener)Construction.construct(listenerClass);
                Listeners.registerListener(listener, manager);
            } else if (parameterTypes.length == 1) {
                EventListener listener = (EventListener)Construction.construct(listenerClass, (Class[])parameterTypes, (Object[])new Object[]{manager});
            }
        }
        catch (Throwable t) {
            throw CommonKnowledgeMessages.MESSAGES.couldNotInstantiateListenerClass(listenerClass.getName());
        }
    }

    private static Constructor<? extends EventListener> getConstructor(Class<? extends EventListener> listenerClass) {
        Constructor<? extends EventListener> constructor = null;
        for (Class<?>[] parameterTypes : PARMAMETER_TYPES) {
            try {
                constructor = listenerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    public static void registerListener(EventListener listener, KieRuntimeEventManager manager) {
        if (listener instanceof KieBaseEventListener) {
            if (manager instanceof StatelessKieSession) {
                ((StatelessKieSession)manager).getKieBase().addEventListener((KieBaseEventListener)listener);
            } else if (manager instanceof KieRuntime) {
                ((KieRuntime)manager).getKieBase().addEventListener((KieBaseEventListener)listener);
            }
        }
        if (listener instanceof AgendaEventListener) {
            manager.addEventListener((AgendaEventListener)listener);
        }
        if (listener instanceof WorkingMemoryEventListener) {
            manager.addEventListener((WorkingMemoryEventListener)listener);
        }
        if (listener instanceof ProcessEventListener) {
            manager.addEventListener((ProcessEventListener)listener);
        }
    }

    private Listeners() {
    }
}

