/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Map;
import java.util.Properties;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.component.common.knowledge.config.model.ContainerModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Channels;
import org.switchyard.component.common.knowledge.util.Configurations;
import org.switchyard.component.common.knowledge.util.Containers;
import org.switchyard.component.common.knowledge.util.Disposals;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Listeners;
import org.switchyard.component.common.knowledge.util.Loggers;

class KnowledgeContainerSessionFactory
extends KnowledgeSessionFactory {
    private final ContainerModel _containerModel;
    private final KieContainer _kieContainer;

    KnowledgeContainerSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        super(model, loader, domain, propertyOverrides);
        this._containerModel = Containers.getContainerModel(model);
        this._kieContainer = Containers.getContainer(this._containerModel);
        this.registerScannerForDisposal();
    }

    @Override
    public KnowledgeSession newStatelessSession() {
        StatelessKieSession stateless = this.newStatelessKieSession();
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateless);
        return new KnowledgeSession(stateless, loggersDisposal);
    }

    @Override
    public KnowledgeSession newStatefulSession(Map<String, Object> environmentOverrides) {
        KieSession stateful = this.newKieSession(environmentOverrides);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateful);
        return new KnowledgeSession(stateful, false, loggersDisposal);
    }

    @Override
    public KnowledgeSession getPersistentSession(Map<String, Object> environmentOverrides, Integer sessionId) {
        KieSession stateful = this.getPersistentKieSession(environmentOverrides, sessionId);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Listeners.registerListeners(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        Channels.registerChannels(this.getModel(), this.getLoader(), this.getDomain(), stateful);
        return new KnowledgeSession(stateful, true, loggersDisposal);
    }

    private StatelessKieSession newStatelessKieSession() {
        if (this._containerModel != null) {
            String sessionName = this._containerModel.getSessionName();
            if (sessionName != null) {
                return this._kieContainer.newStatelessKieSession(sessionName);
            }
            String baseName = this._containerModel.getBaseName();
            if (baseName != null) {
                KieSessionConfiguration sessionConfiguration = Configurations.getSessionConfiguration(this.getModel(), this.getLoader(), this.getPropertyOverrides());
                return this._kieContainer.getKieBase(baseName).newStatelessKieSession(sessionConfiguration);
            }
        }
        return this._kieContainer.newStatelessKieSession();
    }

    private KieSession newKieSession(Map<String, Object> environmentOverrides) {
        Environment environment = Environments.getEnvironment(environmentOverrides);
        if (this._containerModel != null) {
            String sessionName = this._containerModel.getSessionName();
            if (sessionName != null) {
                return this._kieContainer.newKieSession(sessionName, environment);
            }
            String baseName = this._containerModel.getBaseName();
            if (baseName != null) {
                KieSessionConfiguration sessionConfiguration = Configurations.getSessionConfiguration(this.getModel(), this.getLoader(), this.getPropertyOverrides());
                return this._kieContainer.getKieBase(baseName).newKieSession(sessionConfiguration, environment);
            }
        }
        return this._kieContainer.newKieSession(environment);
    }

    private KieSession getPersistentKieSession(Map<String, Object> environmentOverrides, Integer sessionId) {
        String baseName;
        if (this._containerModel != null && (baseName = this._containerModel.getBaseName()) != null) {
            KieStoreServices kieStoreServices = KieServices.Factory.get().getStoreServices();
            KieBase base = this._kieContainer.getKieBase(baseName);
            KieSessionConfiguration sessionConfiguration = Configurations.getSessionConfiguration(this.getModel(), this.getLoader(), this.getPropertyOverrides());
            Environment environment = Environments.getEnvironment(environmentOverrides);
            KieSession session = null;
            if (sessionId != null) {
                session = kieStoreServices.loadKieSession(sessionId.intValue(), base, sessionConfiguration, environment);
            }
            if (session == null) {
                session = kieStoreServices.newKieSession(base, sessionConfiguration, environment);
            }
            return session;
        }
        throw new SwitchYardException("manifest container baseName required in configuration for persistent sessions");
    }

    private void registerScannerForDisposal() {
        if (this._containerModel != null && this._containerModel.isScan()) {
            long si;
            Long scanInterval = this._containerModel.getScanInterval();
            if (scanInterval == null) {
                scanInterval = 60000L;
            }
            if ((si = scanInterval.longValue()) < 1L) {
                throw new IllegalArgumentException("container scanInterval must be positive");
            }
            KieScanner scanner = KieServices.Factory.get().newKieScanner(this._kieContainer);
            this.addDisposals(Disposals.newDisposal(scanner));
            scanner.start(si);
        }
    }
}

