/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.lang.reflect.Constructor;
import java.util.EventListener;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ListenerModel;
import org.switchyard.component.common.knowledge.config.model.ListenersModel;

public final class Listeners {
    private static final Class<?>[][] PARMAMETER_TYPES = new Class[][]{{KieRuntimeEventManager.class}, {KieRuntime.class}, {KnowledgeRuntimeEventManager.class}, {KnowledgeRuntime.class}, new Class[0]};

    public static void registerListeners(KnowledgeComponentImplementationModel model, ClassLoader loader, KieRuntimeEventManager runtimeEventManager) {
        ListenersModel listenersModel;
        if (runtimeEventManager instanceof KieSession) {
            runtimeEventManager.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

                public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                    ((KieSession)event.getKieRuntime()).fireAllRules();
                }
            });
        }
        if ((listenersModel = model.getListeners()) != null) {
            for (ListenerModel listenerModel : listenersModel.getListeners()) {
                Class<?> listenerClass = listenerModel.getClazz(loader);
                if (listenerClass == null) {
                    throw new SwitchYardException("Could not load listener class: " + listenerModel.getModelConfiguration().getAttribute("class"));
                }
                Listeners.registerListener(listenerClass, runtimeEventManager);
            }
        }
    }

    private static void registerListener(Class<? extends EventListener> listenerClass, KieRuntimeEventManager runtimeEventManager) {
        Constructor<? extends EventListener> constructor = Listeners.getConstructor(listenerClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                EventListener listener = (EventListener)Construction.construct(listenerClass);
                Listeners.registerListener(listener, runtimeEventManager);
            } else if (parameterTypes.length == 1) {
                EventListener listener = (EventListener)Construction.construct(listenerClass, (Class[])parameterTypes, (Object[])new Object[]{runtimeEventManager});
            }
        }
        catch (Throwable t) {
            throw new SwitchYardException("Could not instantiate listener class: " + listenerClass.getName());
        }
    }

    private static Constructor<? extends EventListener> getConstructor(Class<? extends EventListener> listenerClass) {
        Constructor<? extends EventListener> constructor = null;
        for (Class<?>[] parameterTypes : PARMAMETER_TYPES) {
            try {
                constructor = listenerClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    public static void registerListener(EventListener listener, KieRuntimeEventManager runtimeEventManager) {
        if (listener instanceof KieBaseEventListener && runtimeEventManager instanceof KieRuntime) {
            ((KieRuntime)runtimeEventManager).getKieBase().addEventListener((KieBaseEventListener)listener);
        }
        if (listener instanceof AgendaEventListener) {
            runtimeEventManager.addEventListener((AgendaEventListener)listener);
        }
        if (listener instanceof WorkingMemoryEventListener) {
            runtimeEventManager.addEventListener((WorkingMemoryEventListener)listener);
        }
        if (listener instanceof ProcessEventListener) {
            runtimeEventManager.addEventListener((ProcessEventListener)listener);
        }
    }

    private Listeners() {
    }
}

