/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.net.URL;
import org.kie.api.KieServices;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.switchyard.common.io.resource.ResourceDetail;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.config.model.resource.ResourceModel;
import org.switchyard.config.model.resource.ResourcesModel;

public final class Resources {
    public static void installTypes(ClassLoader loader) {
        org.switchyard.common.io.resource.ResourceType.install((ClassLoader)loader);
    }

    public static void addResources(KnowledgeComponentImplementationModel model, ClassLoader loader, KnowledgeBuilder builder) {
        ResourcesModel resourcesModel;
        ManifestModel manifestModel = model.getManifest();
        if (manifestModel != null && (resourcesModel = manifestModel.getResources()) != null) {
            KieResources kieResources = KieServices.Factory.get().getResources();
            for (ResourceModel syResource : resourcesModel.getResources()) {
                ResourceType kieResourceType;
                Resource kieResource;
                URL locationURL = syResource.getLocationURL(loader);
                if (locationURL == null || (kieResource = kieResources.newUrlResource(locationURL)) == null || (kieResourceType = Resources.convertResourceType(syResource.getType())) == null) continue;
                DecisionTableConfiguration kieResourceConfiguration = null;
                ResourceDetail syResourceDetail = syResource.getDetail();
                if (syResourceDetail != null && ResourceType.DTABLE.equals((Object)kieResourceType)) {
                    DecisionTableConfiguration dtc = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                    String inputType = Resources.getInputType(syResourceDetail);
                    if (inputType != null) {
                        dtc.setInputType(DecisionTableInputType.valueOf((String)inputType));
                    }
                    dtc.setWorksheetName(syResourceDetail.getWorksheetName());
                    kieResourceConfiguration = dtc;
                }
                builder.add(kieResource, kieResourceType, kieResourceConfiguration);
            }
        }
    }

    private static String getInputType(ResourceDetail syResourceDetail) {
        String inputType = Strings.trimToNull((String)syResourceDetail.getInputType());
        if (inputType != null) {
            inputType = inputType.toUpperCase();
        }
        return inputType;
    }

    public static ResourceType convertResourceType(org.switchyard.common.io.resource.ResourceType syResourceType) {
        if (syResourceType != null) {
            String resourceTypeName = syResourceType.getName();
            if ("BPMN".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.BPMN2.getName();
            } else if ("XLS".equals(resourceTypeName) || "CSV".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.DTABLE.getName();
            }
            return ResourceType.getResourceType((String)resourceTypeName);
        }
        return null;
    }

    private Resources() {
    }
}

