/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.exchange;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.kie.api.runtime.Globals;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeOperation;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Operations;
import org.switchyard.component.common.knowledge.util.Resources;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;

public abstract class KnowledgeExchangeHandler<M extends KnowledgeComponentImplementationModel>
extends BaseServiceHandler
implements ServiceHandler {
    private final String _deploymentId;
    private final M _model;
    private final ServiceDomain _serviceDomain;
    private final QName _serviceName;
    private ClassLoader _loader;
    private final Map<String, KnowledgeOperation> _operations = new HashMap<String, KnowledgeOperation>();
    private KnowledgeSessionFactory _sessionFactory;
    private KnowledgeSession _statefulSession;

    public KnowledgeExchangeHandler(M model, ServiceDomain serviceDomain, QName serviceName) {
        super(serviceDomain);
        this._deploymentId = serviceName.toString();
        this._model = model;
        this._serviceDomain = serviceDomain;
        this._serviceName = serviceName;
    }

    protected String getDeploymentId() {
        return this._deploymentId;
    }

    protected M getModel() {
        return this._model;
    }

    protected ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    protected QName getServiceName() {
        return this._serviceName;
    }

    protected ClassLoader getLoader() {
        return this._loader;
    }

    protected Properties getPropertyOverrides() {
        return new Properties();
    }

    protected Map<String, Object> getEnvironmentOverrides() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("deploymentId", this.getDeploymentId());
        return env;
    }

    protected KnowledgeSession newStatelessSession() {
        return this._sessionFactory.newStatelessSession();
    }

    protected KnowledgeSession getStatefulSession() {
        if (this._statefulSession == null) {
            this._statefulSession = this._sessionFactory.newStatefulSession(this.getEnvironmentOverrides());
        }
        return this._statefulSession;
    }

    protected KnowledgeSession getPersistentSession(Integer sessionId) {
        if (this._statefulSession != null && (!this._statefulSession.isPersistent() || sessionId != null && !sessionId.equals(this._statefulSession.getId()))) {
            this.disposeStatefulSession();
        }
        if (this._statefulSession == null) {
            this._statefulSession = this._sessionFactory.getPersistentSession(this.getEnvironmentOverrides(), sessionId);
        }
        return this._statefulSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeStatefulSession() {
        if (this._statefulSession != null) {
            try {
                this._statefulSession.dispose();
            }
            finally {
                this._statefulSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeSessionFactory() {
        if (this._sessionFactory != null) {
            try {
                this._sessionFactory.dispose();
            }
            finally {
                this._sessionFactory = null;
            }
        }
    }

    protected void doStart() {
        this._loader = Classes.getClassLoader((ClassLoader[])new ClassLoader[]{this.getDeploymentClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()});
        Resources.installTypes(this._loader);
        Operations.registerOperations(this._model, this._operations, this.getDefaultOperation());
        this._sessionFactory = KnowledgeSessionFactory.newSessionFactory(this._model, this._loader, this._serviceDomain, this.getPropertyOverrides());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        this._loader = null;
        this._operations.clear();
        try {
            this.disposeStatefulSession();
        }
        finally {
            this.disposeSessionFactory();
        }
    }

    public abstract KnowledgeOperation getDefaultOperation();

    private KnowledgeOperation getOperation(ServiceOperation serviceOperation) {
        String operationName;
        if (serviceOperation != null && (operationName = Strings.trimToNull((String)serviceOperation.getName())) != null) {
            return this._operations.get(operationName);
        }
        return null;
    }

    public final void handleMessage(Exchange exchange) throws HandlerException {
        if (ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            ExchangeContract contract = exchange.getContract();
            KnowledgeOperation operation = this.getOperation(contract.getProviderOperation());
            if (operation == null) {
                operation = this.getOperation(contract.getConsumerOperation());
            }
            if (operation == null) {
                operation = this._operations.get("default");
            }
            this.handleOperation(exchange, operation);
        }
    }

    public abstract void handleOperation(Exchange var1, KnowledgeOperation var2) throws HandlerException;

    protected boolean isBoolean(Exchange exchange, Message message, String name) {
        Boolean b = this.getBoolean(exchange, message, name);
        return b != null && b != false;
    }

    protected Boolean getBoolean(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(((String)value).trim());
        }
        return false;
    }

    protected Integer getInteger(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf(((String)value).trim());
        }
        return null;
    }

    protected Long getLong(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf(((String)value).trim());
        }
        return null;
    }

    protected String getString(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    protected Object getObject(Exchange exchange, Message message, String name) {
        Context context = message != null ? exchange.getContext(message) : exchange.getContext();
        return context.getPropertyValue(name);
    }

    protected Map<String, Object> getGlobalVariables(KnowledgeSession session) {
        Globals globals;
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        if (session != null && (globals = session.getGlobals()) != null) {
            for (String key : globals.getGlobalKeys()) {
                Object value = globals.get(key);
                globalVariables.put(key, value);
            }
        }
        return globalVariables;
    }
}

