/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.expression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;
import org.switchyard.common.property.PropertyResolver;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionType;

public class MVELExpression
implements Expression {
    private final String _expression;
    private final PropertyResolverFactory _propertyResolverFactory;
    private Serializable _compiled;

    public MVELExpression(String expression, PropertyResolver propertyResolver) {
        this._expression = expression;
        this._propertyResolverFactory = new PropertyResolverFactory(propertyResolver);
        this.compile();
    }

    @Override
    public String getExpression() {
        return this._expression;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.MVEL;
    }

    private void compile() {
        ParserContext pc = new ParserContext();
        pc.addPackageImport("java.util");
        pc.addPackageImport("org.switchyard");
        this._compiled = MVEL.compileExpression((String)this._expression, (ParserContext)pc);
    }

    @Override
    public boolean isCompiled() {
        return this._compiled != null;
    }

    @Override
    public Object run() {
        return this.run(null);
    }

    @Override
    public Object run(Map<String, Object> variables) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        MapVariableResolverFactory factory = new MapVariableResolverFactory(variables, (VariableResolverFactory)this._propertyResolverFactory);
        return this.isCompiled() ? MVEL.executeExpression((Object)this._compiled, (VariableResolverFactory)factory) : MVEL.eval((String)this._expression, (VariableResolverFactory)factory);
    }

    private static final class PropertyResolverFactory
    extends ImmutableDefaultFactory {
        private final PropertyResolver _propertyResolver;

        private PropertyResolverFactory(PropertyResolver propertyResolver) {
            this._propertyResolver = propertyResolver;
        }

        public boolean isResolveable(String name) {
            return name != null && this._propertyResolver.resolveProperty(name) != null;
        }

        public VariableResolver getVariableResolver(String name) {
            Object value = name != null ? this._propertyResolver.resolveProperty(name) : null;
            return new SimpleValueResolver(value);
        }
    }
}

