/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.command.Command;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.runtime.KieSession;
import org.kie.services.client.api.RemoteJmsRuntimeEngineFactory;
import org.kie.services.client.api.RemoteRestRuntimeEngineFactory;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.builder.RemoteJmsRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.builder.RemoteRestRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.builder.RemoteRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.command.RemoteRuntimeEngine;
import org.kie.services.shared.AcceptedCommands;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.common.knowledge.config.model.ExtraJaxbClassModel;
import org.switchyard.component.common.knowledge.config.model.ExtraJaxbClassesModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.RemoteJmsModel;
import org.switchyard.component.common.knowledge.config.model.RemoteModel;
import org.switchyard.component.common.knowledge.config.model.RemoteRestModel;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;
import org.switchyard.component.common.knowledge.session.KnowledgeRemoteStatelessKieSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.session.KnowledgeSessionFactory;
import org.switchyard.component.common.knowledge.util.Loggers;

public class KnowledgeRemoteSessionFactory
extends KnowledgeSessionFactory {
    private static Set<Class<? extends Command>> acceptedCommands = new HashSet<Class<? extends Command>>();
    private final RemoteRuntimeEngineFactory _remoteRuntimeEngineFactory = this.buildRemoteRuntimeEngineFactory();

    KnowledgeRemoteSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        super(model, loader, domain, propertyOverrides);
    }

    @Override
    public KnowledgeSession newStatelessSession() {
        RemoteRuntimeEngine remoteRuntimeEngine = this._remoteRuntimeEngineFactory.newRuntimeEngine();
        KnowledgeRemoteStatelessKieSession stateless = new KnowledgeRemoteStatelessKieSession(remoteRuntimeEngine);
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateless);
        return new KnowledgeSession(stateless, true, loggersDisposal);
    }

    @Override
    public KnowledgeSession newStatefulSession(Map<String, Object> environmentOverrides) {
        RemoteRuntimeEngine remoteRuntimeEngine = this._remoteRuntimeEngineFactory.newRuntimeEngine();
        KieSession stateful = remoteRuntimeEngine.getKieSession();
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        return new KnowledgeSession(stateful, true, false, loggersDisposal);
    }

    @Override
    public KnowledgeSession getPersistentSession(Map<String, Object> environmentOverrides, Integer sessionId) {
        RemoteRuntimeEngine remoteRuntimeEngine = this._remoteRuntimeEngineFactory.newRuntimeEngine();
        KieSession stateful = remoteRuntimeEngine.getKieSession();
        KnowledgeDisposal loggersDisposal = Loggers.registerLoggersForDisposal(this.getModel(), this.getLoader(), (KieRuntimeEventManager)stateful);
        return new KnowledgeSession(stateful, true, true, loggersDisposal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteRuntimeEngineFactory buildRemoteRuntimeEngineFactory() {
        RemoteRuntimeEngineFactory factory = null;
        ClassLoader loader = this.getLoader();
        RemoteModel remoteModel = this.getModel().getManifest().getRemote();
        if (remoteModel instanceof RemoteJmsModel) {
            RemoteJmsRuntimeEngineFactoryBuilder builder = RemoteJmsRuntimeEngineFactory.newBuilder();
            InitialContext ctx = this.configRemoteJms(builder, (RemoteJmsModel)remoteModel, loader);
            try {
                factory = (RemoteRuntimeEngineFactory)builder.build();
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e) {
                        e.getMessage();
                    }
                }
            }
        }
        if (remoteModel instanceof RemoteRestModel) {
            RemoteRestRuntimeEngineFactoryBuilder builder = RemoteRestRuntimeEngineFactory.newBuilder();
            this.configRemoteRest(builder, (RemoteRestModel)remoteModel, loader);
            factory = (RemoteRuntimeEngineFactory)builder.build();
        }
        return factory;
    }

    private InitialContext configRemoteJms(RemoteJmsRuntimeEngineFactoryBuilder builder, RemoteJmsModel model, ClassLoader loader) {
        String truststoreLocation;
        String truststorePassword;
        String keystoreLocation;
        this.configRemote((RemoteRuntimeEngineFactoryBuilder<?, ?>)builder, model, loader);
        InitialContext ctx = null;
        String hostName = model.getHostName();
        if (hostName != null) {
            builder.addHostName(hostName);
            try {
                String password;
                Properties props = new Properties();
                props.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
                Integer remotingPort = model.getRemotingPort();
                if (remotingPort == null) {
                    remotingPort = 4447;
                }
                props.setProperty("java.naming.provider.url", "remote://" + hostName + ":" + remotingPort);
                String userName = model.getUserName();
                if (userName != null) {
                    props.setProperty("java.naming.security.principal", userName);
                }
                if ((password = model.getPassword()) != null) {
                    props.setProperty("java.naming.security.credentials", password);
                }
                ctx = new InitialContext(props);
                builder.addRemoteInitialContext(ctx);
            }
            catch (NamingException ne) {
                throw new RuntimeException(ne);
            }
        }
        try {
            ctx = new InitialContext();
            builder.addRemoteInitialContext(ctx);
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        Integer messagingPort = model.getMessagingPort();
        if (messagingPort == null) {
            messagingPort = 5455;
        }
        builder.addJmsConnectorPort(messagingPort.intValue());
        builder.useSsl(model.isUseSsl());
        String keystorePassword = model.getKeystorePassword();
        if (keystorePassword != null) {
            builder.addKeystorePassword(keystorePassword);
            builder.addTruststorePassword(keystorePassword);
        }
        if ((keystoreLocation = model.getKeystoreLocation()) != null) {
            builder.addKeystoreLocation(keystoreLocation);
            builder.addTruststoreLocation(keystoreLocation);
        }
        if ((truststorePassword = model.getTruststorePassword()) != null) {
            builder.addTruststorePassword(truststorePassword);
        }
        if ((truststoreLocation = model.getTruststoreLocation()) != null) {
            builder.addTruststoreLocation(truststoreLocation);
        }
        return ctx;
    }

    private void configRemoteRest(RemoteRestRuntimeEngineFactoryBuilder builder, RemoteRestModel model, ClassLoader loader) {
        this.configRemote((RemoteRuntimeEngineFactoryBuilder<?, ?>)builder, model, loader);
        try {
            builder.addUrl(new URL(model.getUrl()));
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        builder.useFormBasedAuth(model.isUseFormBasedAuth());
    }

    private void configRemote(RemoteRuntimeEngineFactoryBuilder<?, ?> builder, RemoteModel model, ClassLoader loader) {
        ExtraJaxbClassesModel extraJaxbClasses;
        Integer timeout;
        String password;
        builder.addDeploymentId(model.getDeploymentId());
        String userName = model.getUserName();
        if (userName != null) {
            builder.addUserName(userName);
        }
        if ((password = model.getPassword()) != null) {
            builder.addPassword(password);
        }
        if ((timeout = model.getTimeout()) != null) {
            builder.addTimeout(timeout.intValue());
        }
        if ((extraJaxbClasses = model.getExtraJaxbClasses()) != null) {
            LinkedHashSet clazzes = new LinkedHashSet();
            for (ExtraJaxbClassModel extraJaxbClass : extraJaxbClasses.getExtraJaxbClasses()) {
                Class<?> clazz = extraJaxbClass.getClazz(loader);
                if (clazz == null) continue;
                clazzes.add(clazz);
            }
            int cs = clazzes.size();
            if (cs > 0) {
                builder.addExtraJaxbClasses(clazzes.toArray(new Class[cs]));
            }
        }
        builder.addExtraJaxbClasses(acceptedCommands.toArray(new Class[acceptedCommands.size()]));
    }

    static {
        acceptedCommands.addAll(AcceptedCommands.getSet());
        acceptedCommands.add(BatchExecutionCommandImpl.class);
        acceptedCommands = Collections.unmodifiableSet(acceptedCommands);
        FieldAccess access = new FieldAccess(AcceptedCommands.class, "acceptedCommands");
        access.write(null, acceptedCommands);
    }
}

