/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.services.client.api.command.RemoteRuntimeEngine;

public class KnowledgeRemoteStatelessKieSession
implements StatelessKieSession {
    private final RemoteRuntimeEngine _remoteRuntimeEngine;
    private KieSession _ksession;

    KnowledgeRemoteStatelessKieSession(RemoteRuntimeEngine remoteRuntimeEngine) {
        this._remoteRuntimeEngine = remoteRuntimeEngine;
        this.newSession();
    }

    private KieSession getSession() {
        return this._ksession;
    }

    private void newSession() {
        this._ksession = this._remoteRuntimeEngine.getKieSession();
    }

    public void execute(Object object) {
        this.newSession();
        this.getSession().insert(object);
        this.getSession().fireAllRules();
    }

    public void execute(Iterable objects) {
        this.newSession();
        for (Object object : objects) {
            this.getSession().insert(object);
        }
        this.getSession().fireAllRules();
    }

    public <T> T execute(Command<T> command) {
        this.newSession();
        Object t = this.getSession().execute(command);
        return (T)t;
    }

    public KieRuntimeLogger getLogger() {
        return this.getSession().getLogger();
    }

    public void addEventListener(RuleRuntimeEventListener listener) {
    }

    public void removeEventListener(RuleRuntimeEventListener listener) {
    }

    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return Collections.emptyList();
    }

    public void addEventListener(AgendaEventListener listener) {
    }

    public void removeEventListener(AgendaEventListener listener) {
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return Collections.emptyList();
    }

    public void addEventListener(ProcessEventListener listener) {
    }

    public void removeEventListener(ProcessEventListener listener) {
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return Collections.emptyList();
    }

    public Globals getGlobals() {
        return null;
    }

    public void setGlobal(String identifier, Object value) {
        this.getSession().setGlobal(identifier, value);
    }

    public void registerChannel(String name, Channel channel) {
        this.getSession().registerChannel(name, channel);
    }

    public void unregisterChannel(String name) {
        this.getSession().unregisterChannel(name);
    }

    public Map<String, Channel> getChannels() {
        return this.getSession().getChannels();
    }

    public KieBase getKieBase() {
        return null;
    }
}

