/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.session;

import java.util.Map;
import java.util.Properties;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.component.common.knowledge.config.model.RemoteModel;
import org.switchyard.component.common.knowledge.session.KnowledgeBuilderSessionFactory;
import org.switchyard.component.common.knowledge.session.KnowledgeContainerSessionFactory;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposer;
import org.switchyard.component.common.knowledge.session.KnowledgeRemoteSessionFactory;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.config.model.resource.ResourcesModel;

public abstract class KnowledgeSessionFactory
extends KnowledgeDisposer {
    private final KnowledgeComponentImplementationModel _model;
    private final ClassLoader _loader;
    private final ServiceDomain _domain;
    private final Properties _propertyOverrides;

    protected KnowledgeSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        this._model = model;
        this._loader = loader;
        this._domain = domain;
        this._propertyOverrides = propertyOverrides;
    }

    public KnowledgeComponentImplementationModel getModel() {
        return this._model;
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public Properties getPropertyOverrides() {
        return this._propertyOverrides;
    }

    public abstract KnowledgeSession newStatelessSession();

    public abstract KnowledgeSession newStatefulSession(Map<String, Object> var1);

    public abstract KnowledgeSession getPersistentSession(Map<String, Object> var1, Integer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KnowledgeSessionFactory newSessionFactory(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, Properties propertyOverrides) {
        ClassLoader origTCCL = Classes.setTCCL((ClassLoader)loader);
        try {
            ManifestModel manifestModel = model.getManifest();
            if (manifestModel != null && manifestModel.getContainer() == null) {
                ResourcesModel resourcesModel = manifestModel.getResources();
                if (resourcesModel != null) {
                    KnowledgeBuilderSessionFactory knowledgeBuilderSessionFactory = new KnowledgeBuilderSessionFactory(model, loader, domain, propertyOverrides);
                    return knowledgeBuilderSessionFactory;
                }
                RemoteModel remoteModel = manifestModel.getRemote();
                if (remoteModel != null) {
                    KnowledgeRemoteSessionFactory knowledgeRemoteSessionFactory = new KnowledgeRemoteSessionFactory(model, loader, domain, propertyOverrides);
                    return knowledgeRemoteSessionFactory;
                }
            }
            KnowledgeContainerSessionFactory knowledgeContainerSessionFactory = new KnowledgeContainerSessionFactory(model, loader, domain, propertyOverrides);
            return knowledgeContainerSessionFactory;
        }
        finally {
            Classes.setTCCL((ClassLoader)origTCCL);
        }
    }
}

