/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.model.ChannelModel;
import org.switchyard.component.common.knowledge.config.model.ChannelsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceChannel;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.deploy.ComponentNames;

public final class Channels {
    public static void registerChannels(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, StatelessKieSession stateless) {
        List<NameChannel> ncList = Channels.getNameChannels(model, loader, domain);
        for (NameChannel nc : ncList) {
            stateless.registerChannel(nc.getName(), nc.getChannel());
        }
    }

    public static void registerChannels(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain, KieSession stateful) {
        List<NameChannel> ncList = Channels.getNameChannels(model, loader, domain);
        for (NameChannel nc : ncList) {
            stateful.registerChannel(nc.getName(), nc.getChannel());
        }
    }

    private static List<NameChannel> getNameChannels(KnowledgeComponentImplementationModel model, ClassLoader loader, ServiceDomain domain) {
        ArrayList<NameChannel> ncList = new ArrayList<NameChannel>();
        ChannelsModel channelsModel = model.getChannels();
        if (channelsModel != null) {
            ComponentModel componentModel = model.getComponent();
            QName componentName = componentModel.getQName();
            String componentTNS = componentModel.getTargetNamespace();
            for (ChannelModel channelModel : channelsModel.getChannels()) {
                Class<Object> channelClass = channelModel.getClazz(loader);
                if (channelClass == null) {
                    channelClass = SwitchYardServiceChannel.class;
                }
                Channel channel = (Channel)Construction.construct(channelClass);
                String name = channelModel.getName();
                if (channel instanceof SwitchYardServiceChannel) {
                    SwitchYardServiceChannel sysc = (SwitchYardServiceChannel)channel;
                    if (name != null) {
                        sysc.setName(name);
                    } else {
                        name = sysc.getName();
                    }
                    QName serviceName = XMLHelper.createQName((String)channelModel.getReference());
                    if (serviceName != null && componentName != null) {
                        serviceName = ComponentNames.qualify((QName)componentName, (QName)ComponentNames.unqualify((QName)serviceName));
                    }
                    sysc.setServiceName(serviceName);
                    sysc.setOperationName(channelModel.getOperation());
                    sysc.setInvoker(new SwitchYardServiceInvoker(domain, componentTNS));
                }
                if (name == null) {
                    throw CommonKnowledgeMessages.MESSAGES.couldNotUseNullNameToRegisterChannel(channel.getClass().getName());
                }
                ncList.add(new NameChannel(name, channel));
            }
        }
        return ncList;
    }

    private Channels() {
    }

    private static final class NameChannel {
        private final String _name;
        private final Channel _channel;

        private NameChannel(String name, Channel channel) {
            this._name = name;
            this._channel = channel;
        }

        private String getName() {
            return this._name;
        }

        private Channel getChannel() {
            return this._channel;
        }
    }
}

