/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.switchyard.component.common.knowledge.config.model.ContainerModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;

public final class Containers {
    public static ReleaseId toReleaseId(String releaseId) {
        if (releaseId != null) {
            String[] gav = releaseId.split(":", 3);
            String groupId = gav.length > 0 ? gav[0] : null;
            String artifactId = gav.length > 1 ? gav[1] : null;
            String version = gav.length > 2 ? gav[2] : null;
            return Containers.toReleaseId(groupId, artifactId, version);
        }
        return null;
    }

    public static ReleaseId toReleaseId(String groupId, String artifactId, String version) {
        return KieServices.Factory.get().newReleaseId(groupId, artifactId, version);
    }

    public static ContainerModel getContainerModel(KnowledgeComponentImplementationModel model) {
        ManifestModel manifestModel;
        if (model != null && (manifestModel = model.getManifest()) != null) {
            return manifestModel.getContainer();
        }
        return null;
    }

    public static KieContainer getContainer(ContainerModel model) {
        ReleaseId releaseId;
        KieServices kieServices = KieServices.Factory.get();
        if (model != null && (releaseId = Containers.toReleaseId(model.getReleaseId())) != null) {
            return kieServices.newKieContainer(releaseId);
        }
        return kieServices.newKieClasspathContainer();
    }

    private Containers() {
    }
}

