/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.kie.api.builder.KieScanner;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.session.KnowledgeDisposal;

public final class Disposals {
    public static KnowledgeDisposal newDisposal(final EntityManagerFactory entityManagerFactory) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                try {
                    if (entityManagerFactory != null) {
                        entityManagerFactory.close();
                    }
                }
                catch (Throwable t) {
                    CommonKnowledgeLogger.ROOT_LOGGER.problemClosingEntityManagerFactory(t.getMessage());
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final List<KieRuntimeLogger> kieRuntimeLoggers) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                if (kieRuntimeLoggers != null) {
                    for (KieRuntimeLogger kieRuntimeLogger : kieRuntimeLoggers) {
                        try {
                            if (kieRuntimeLogger == null) continue;
                            kieRuntimeLogger.close();
                        }
                        catch (Throwable t) {
                            CommonKnowledgeLogger.ROOT_LOGGER.problemClosingKieRuntimeLogger(t.getMessage());
                        }
                    }
                    kieRuntimeLoggers.clear();
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final KieScanner kieScanner) {
        return new KnowledgeDisposal(){

            @Override
            public void dispose() {
                try {
                    if (kieScanner != null) {
                        kieScanner.stop();
                    }
                }
                catch (Throwable t) {
                    CommonKnowledgeLogger.ROOT_LOGGER.problemStopppingKieScanner(t.getMessage());
                }
            }
        };
    }

    public static KnowledgeDisposal newDisposal(final KieSession kieSession) {
        return new KnowledgeDisposal(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                block5: {
                    try {
                        if (kieSession == null) break block5;
                        try {
                            kieSession.halt();
                        }
                        finally {
                            kieSession.dispose();
                        }
                    }
                    catch (Throwable t) {
                        CommonKnowledgeLogger.ROOT_LOGGER.problemDisposingKieSession(t.getMessage());
                    }
                }
            }
        };
    }

    private Disposals() {
    }
}

